# SPDX-FileCopyrightText: 2023 Simon Dalvai <info@simondalvai.org>

# SPDX-License-Identifier: AGPL-3.0-or-later

extends Control

signal back

func _ready() -> void:
	$VBoxContainer/Buttons/Donate.visible = Global.FDROID or OS.get_name() == "HTML5"
	$VBoxContainer/Buttons/Website.visible = not $VBoxContainer/Buttons/Donate.visible

func _on_Back_pressed() -> void:
	emit_signal("back")


func _on_Website_pressed() -> void:
	AudioMachine.click()
	OS.shell_open("https://simondalvai.org")



func _on_RichTextLabel_meta_clicked(meta) -> void:
	OS.shell_open(meta)
	AudioMachine.click()


func _on_Donate_pressed():
	AudioMachine.click()
	OS.shell_open("https://simondalvai.org/donate")


func _on_SourceCode_pressed() -> void:
	AudioMachine.click()
	OS.shell_open("https://codeberg.org/dulvui/ball2box")

