<!--
SPDX-FileCopyrightText: 2023 Simon Dalvai <info@simondalvai.org>

SPDX-License-Identifier: CC0-1.0
-->
# Roadmap
List of features/issues for future versions of Ball2Box.  
So users from [Codeberg](https://codeberg.org/dulvui/ball2box) and [Github](https://codeberg.org/dulvui/ball2box) can track issues/features with ease.

## Table of contents
- [Roadmap](#roadmap)
  - [Table of contents](#table-of-contents)
  - [Backlog](#backlog)
  - [In progress](#in-progress)
  - [Done](#done)

## Backlog
Features/issues that will [probably] be added/solved in future

- Level Editor - https://github.com/dulvui/ball2box/issues/15
    - level crud (create, read, update, delete) editor
    - sharing levels
        - base64 string
        - web service
        - email

- Is the game godot 4.0.1 compatible? - https://github.com/dulvui/ball2box/issues/6
    - at this point, it makes sense to wait for Godot 4.3
    - meshes and textures are broken

- Issues and Questions - https://github.com/dulvui/ball2box/issues/9
    - fix ball swallow

## In progress
List of features that are currently worked on.

- (when) will there be new levels? - https://github.com/dulvui/ball2box/issues/14
    - new background
    - new game mechanics
        - portals


## Done 
Features/issues that are added/solved in specific version

- 4.1.8
    - Update to Godot 3.6.1

- 4.1.6
    - Bug: resetting ball (and level) doesn't always respawn all purple boxes - https://github.com/dulvui/ball2box/issues/20
    - Level 113: move rotator, to fit first ball
    - Level 114: move resizing circle, to fit first ball

- 4.1.5
    - Ball gets stuck in narrow places - https://github.com/dulvui/ball2box/issues/19

- 4.1.4
    - fix menu alignment

- 4.1.3
    - Z-fighting on level 65 - https://github.com/dulvui/ball2box/issues/17
        - fixed also level 67 
    - Fullscreen button please - https://github.com/dulvui/ball2box/issues/18 
    - Godot 3.6 update

- 4.1.2
    - laod correct level when using level selector screen

- 4.1.1
    - 4.1.0 bugs: Keeps reverting to default ball when selecting "next" - https://github.com/dulvui/ball2box/issues/16
