# Quotes.app 💭

<img width="1024" height="500" alt="Quotes" src="https://github.com/user-attachments/assets/4e01e512-295f-4ea5-8a65-4a76961a7235" />


### Quotes App is built to demonstrate the use of Modern Android development tools.
### The app follows latest android principles and components




### Get From
> [<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" height="80">](https://f-droid.org/en/packages/com.shalenmathew.quotesapp)
> [<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" height="80">](https://apt.izzysoft.de/fdroid/index/apk/com.shalenmathew.quotesapp)
> [<img src="https://github.com/vishal2376/snaptick/assets/38159691/f502e2ec-dbf4-4ed6-b23f-a47b74080fea" height="80">](https://github.com/shalenMathew/Quotes-app/releases)

## Built with
> [<img src="https://ziadoua.github.io/m3-Markdown-Badges/badges/Android/android2.svg">]()
> [<img src="https://ziadoua.github.io/m3-Markdown-Badges/badges/Kotlin/kotlin2.svg">]()

## Socials
> [<img src="https://ziadoua.github.io/m3-Markdown-Badges/badges/Discord/discord2.svg">](https://discord.gg/QpDJh3rT4q)
> [<img src="https://ziadoua.github.io/m3-Markdown-Badges/badges/Twitter/twitter1.svg">](https://x.com/shalenmathew)

### This project will be best for you if ur someone who are looking to learn more about android development or
### Who are trying to find simpler projects to begin their contribution journey

## Trailer 📽️

<img src="https://github.com/user-attachments/assets/d566613b-4bb8-43be-a4e6-f21ce8487b57" alt="Trailer GIF" width="700" >

![Adobe Express - 416798702-38a15a1e-b324-4355-8574-49e83cf044cd](https://github.com/user-attachments/assets/bbeb71e4-5d6c-424e-916c-3cb157b6c534)

## Screenshots 📱

| ![ln 3](https://github.com/user-attachments/assets/6aa573aa-2f7f-49db-9a06-ba0431356352) | ![ps2](https://github.com/user-attachments/assets/bf0dc10d-e73a-4f3c-99bf-dcfbf2a8e53f) |
|:-----------------------------------------------------------------------------------------|:---------------------------------------------------------------------------------------:|
| ![ps3](https://github.com/user-attachments/assets/7bff2bac-7f71-43c4-9a5e-0b820bef81c8)  | ![ps4](https://github.com/user-attachments/assets/d1c42711-d1b1-406c-bb20-0faaf3ccf97b)  |
| ![ps5](https://github.com/user-attachments/assets/4adceb39-b558-41d1-9a07-d3a8c5e37345)  | ![ps6](https://github.com/user-attachments/assets/fe16e863-6f2e-4d64-a753-6beda8a0a0b1)  | 
| ![ps1](https://github.com/user-attachments/assets/03aaf7fc-5b3a-416b-9fe8-af6bc3747d95)  |   | 


## Built With 🛠

- **Kotlin**: primary language for modern Android development  
- **Jetpack Compose**: declarative UI framework  
- **Coroutines & Flow**: asynchronous and reactive programming for smooth, non-blocking operations  
- **Clean Architecture (MVVM)**: separation of concerns between UI, business logic, and data  
- **Hilt**: dependency injection  
- **Retrofit**: networking and API integration  
- **Room**: local database for offline-first data persistence  
- **WorkManager**: periodic background tasks (app uses this for sending notifications)  
- **Notifications**: notify users with new quotes
- - **Widgets**: home-screen widget that refreshes every 24 hours with new quotes
- **CI/CD**: automated builds, lint checks, tests, and APK distribution via Discord  
- **Unit & Instrumentation Tests**: ensures correctness across database, repository, and UI layers


## 🚀 Features
- ✨ fresh motivational quotes daily
- 📂 save favorites offline
- 📤 share quotes with friends & family
- 🏠 home screen widget (auto-refreshes every 24hrs)
- 🔔 daily inspiration via notifications


## Contribution/Issues 🤝
- If your new to open source and want to play around with contribution you can do it here or u can raise issue if you want to make any improvements or fix any bugs

  ### Contribution Guide 🚀:
 - Check open issues labeled "good first issue", or "help wanted". If your idea’s not there, open a new issue and let’s chat about it first.
 - Fork the repo and get it running on your setup.
 - Once you’ve made changes, commit and raise a Pull Request against the development branch (we test stuff here before it hits master 🤓).
 - Add a clear title and description: Explain what you changed, why, and how to test it.

  That’s it! Appreciate the help big time… let’s goooo!! 🎉
  
- Tip for beginners : Try to fix small bugs and dont get overwhelmed by the source code , take your time... Start by making small fixes or making small changes 👍

  ## Star History

<a href="https://www.star-history.com/#shalenMathew/Quotes-app&Timeline">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=shalenMathew/Quotes-app&type=Timeline&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=shalenMathew/Quotes-app&type=Timeline" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=shalenMathew/Quotes-app&type=Timeline" />
 </picture>
</a>

## Contact 📧
Connect me using shalenmj@gmail.com

Twitter - https://twitter.com/shalenMathew

Linkedln - https://www.linkedin.com/in/shalen-mathew-3b566921b/

Linktree - https://linktr.ee/shalenmathew


