
# MovieFlix 🍿🎞️🥤

![Adobe Express - rec (1)](https://github.com/user-attachments/assets/f7c5b24e-4606-49f3-a809-e9a39c7e6f1b)



### A movie diary for cinephile for tracking every movie and TV show you watch.

Create aesthetic movie cards to share like Spotify songs, manage your watchlist, track episode-by-episode progress, dive deep into cast filmographies, and maintain your personal movie diary—all in one beautifully designed Android app powered by TMDB API.

### Get From
> [<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" height="80">]()
> [<img src="https://github.com/vishal2376/snaptick/assets/38159691/f502e2ec-dbf4-4ed6-b23f-a47b74080fea" height="80">](https://github.com/shalenMathew/MovieFlix_App/releases)

## Built with
> [<img src="https://ziadoua.github.io/m3-Markdown-Badges/badges/Android/android2.svg">]()
> [<img src="https://ziadoua.github.io/m3-Markdown-Badges/badges/Kotlin/kotlin2.svg">]()

## Socials
> [<img src="https://ziadoua.github.io/m3-Markdown-Badges/badges/Discord/discord2.svg">](https://discord.gg/QpDJh3rT4q)
> [<img src="https://ziadoua.github.io/m3-Markdown-Badges/badges/Twitter/twitter1.svg">](https://x.com/shalenmathew)


## Trailer 📽️

![Adobe Express - ORBIT-5-01-LITE](https://github.com/user-attachments/assets/59777f5b-0e67-4dde-9a13-a4c4bb860153)

## Screenshots 📱

| ![ps1](https://github.com/user-attachments/assets/fbda1306-fe35-46ad-a38d-c8e164ec6a94) | ![ps2](https://github.com/user-attachments/assets/4675976f-9d32-4c33-8f3c-d2e42f591b96) |
|:-----------------------------------------------------------------------------------------|:---------------------------------------------------------------------------------------:|
| ![ps3](https://github.com/user-attachments/assets/fd008344-126a-49ae-9699-da5092f9d291)  | ![ps4](https://github.com/user-attachments/assets/d667ee51-0e1e-481b-b66f-0f970506a335)  |
 

## Features ⚙️

- Discover movies and show
- Offline support
- Save Movies in WatchList & Favourites
- Share movies with family and friends
- Watch official trailers instantly
- Search for your favourite movies and shows
- Get details about the latest episodes of your favourite shows
- Add personal notes to your favourite movies & shows
- Schedule and get notified when it’s time to watch

## 🚀 Roadmap

MovieFlix is actively under development. Here's what's coming next:

- [ ] Add episodes list in the app and the ability to strike them once completed
- [ ] Add a progress tracker to track movies or series
- [x] ~~Bring watchlist and favorites under one screen~~
- [x] ~~Feature to add personal notes under movies~~
- [x] ~~Add pagination feature on list of movies on HomeFeed~~
- [x] ~~Notify when to watch movie by allowing users to schedule time~~
- [x] ~~Add bottom nav~~
- [x] ~~Show whole cast working in a movie with their socials~~

## Built With 🛠
- Kotlin
- Flow
- Coroutines
- LiveData
- Clean Architecture(MVVM)
- DataBinding
- Hilt
- XML
- Glide
- Room
- Retrofit

## Contribution/Issues 🤝
- If your new to open source and want to play around with contribution you can do it here or u can raise issue if you want to make any improvements or fix any bugs

  
  ### How to build the project :
  - Clone the project
  - Get your api key from TMDb website
  - in the project folder in locoal.properties save ur api key in movieApiKey field , just like this movieApiKey="your_actual_api_key_here"

  ### Contribution Guide 🚀:
 - Check open issues labeled "good first issue", or "help wanted". If your idea’s not there, open a new issue and let’s chat about it first.
 - Once you’ve made changes, commit and raise a Pull Request against the development branch (we test stuff here before it hits master 🤓).
 - Add a clear title and description: Explain what you changed, why, and how to test it.

  That’s it! Appreciate the help big time… let’s goooo!! 🎉
  
- Tip for beginners : Try to fix small bugs and dont get overwhelmed by the source code , take your time... Start by making small fixes or making small changes 👍


  ## Star History

<a href="https://www.star-history.com/#shalenMathew/MovieFlix_App&type=date&legend=top-left">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=shalenMathew/MovieFlix_App&type=date&theme=dark&legend=top-left" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=shalenMathew/MovieFlix_App&type=date&legend=top-left" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=shalenMathew/MovieFlix_App&type=date&legend=top-left" />
 </picture>
</a>


## Contact 📧
Connect me using shalenmj@gmail.com

Twitter - https://twitter.com/shalenMathew

Linkedln - https://www.linkedin.com/in/shalen-mathew-3b566921b/
