/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package com.sdcardstoryteller;

public class Constants {

    public static final int SECTOR_SIZE = 512;

    public static final int PACKS_LIST_SECTOR = 100000;

    public static final byte[] CHECK_BYTES = {
            (byte) 0x5F, (byte) 0xCE, (byte) 0xD6, (byte) 0x7E, (byte) 0x0E, (byte) 0x50, (byte) 0x46, (byte) 0xB8,
            (byte) 0xAE, (byte) 0x55, (byte) 0xDA, (byte) 0x8C, (byte) 0x45, (byte) 0xC8, (byte) 0x98, (byte) 0x8A,
            (byte) 0xA3, (byte) 0x87, (byte) 0xA5, (byte) 0x31, (byte) 0x3B, (byte) 0x77, (byte) 0x47, (byte) 0x76,
            (byte) 0xB0, (byte) 0x81, (byte) 0x53, (byte) 0x7D, (byte) 0xD5, (byte) 0x96, (byte) 0x2F, (byte) 0x34,
            (byte) 0xDD, (byte) 0x38, (byte) 0x88, (byte) 0x05, (byte) 0xCA, (byte) 0x4E, (byte) 0x44, (byte) 0xE1,
            (byte) 0xB1, (byte) 0x54, (byte) 0x59, (byte) 0xBE, (byte) 0xB3, (byte) 0x48, (byte) 0x9A, (byte) 0xD7,
            (byte) 0x5F, (byte) 0x53, (byte) 0xAA, (byte) 0x17, (byte) 0xF6, (byte) 0x36, (byte) 0x4E, (byte) 0x38,
            (byte) 0xAA, (byte) 0x21, (byte) 0x49, (byte) 0xB2, (byte) 0xA7, (byte) 0xC1, (byte) 0xDC, (byte) 0x06,
            (byte) 0x73, (byte) 0x11, (byte) 0x68, (byte) 0x92, (byte) 0x65, (byte) 0xEC, (byte) 0x49, (byte) 0x18,
            (byte) 0x82, (byte) 0x37, (byte) 0x8B, (byte) 0xB4, (byte) 0xE9, (byte) 0xB8, (byte) 0x9B, (byte) 0x33,
            (byte) 0x01, (byte) 0x15, (byte) 0xCC, (byte) 0x35, (byte) 0x4E, (byte) 0xDC, (byte) 0x4E, (byte) 0x7A,
            (byte) 0x92, (byte) 0x4D, (byte) 0x4A, (byte) 0x03, (byte) 0x03, (byte) 0xD9, (byte) 0x4D, (byte) 0x22,
            (byte) 0xEC, (byte) 0xC0, (byte) 0x23, (byte) 0xCE, (byte) 0x5A, (byte) 0xAD, (byte) 0x40, (byte) 0x04,
            (byte) 0xAE, (byte) 0xA1, (byte) 0x06, (byte) 0x7D, (byte) 0x40, (byte) 0x1F, (byte) 0x63, (byte) 0xF2,
            (byte) 0xE6, (byte) 0xE2, (byte) 0xB1, (byte) 0xC6, (byte) 0x38, (byte) 0xA2, (byte) 0x4E, (byte) 0xC2,
            (byte) 0xA7, (byte) 0x3B, (byte) 0x2D, (byte) 0x95, (byte) 0x97, (byte) 0x7C, (byte) 0xE9, (byte) 0xC6,
            (byte) 0xCA, (byte) 0x7A, (byte) 0x6A, (byte) 0xDB, (byte) 0xCB, (byte) 0x96, (byte) 0x4D, (byte) 0x2D,
            (byte) 0x9E, (byte) 0x86, (byte) 0xB6, (byte) 0x72, (byte) 0x0A, (byte) 0xD5, (byte) 0x5A, (byte) 0xCA,
            (byte) 0xC2, (byte) 0x7B, (byte) 0x85, (byte) 0x33, (byte) 0x91, (byte) 0x62, (byte) 0x45, (byte) 0x86,
            (byte) 0x9D, (byte) 0xE7, (byte) 0x45, (byte) 0xC1, (byte) 0xE7, (byte) 0xD1, (byte) 0xC9, (byte) 0xDC,
            (byte) 0xBA, (byte) 0x9B, (byte) 0xD4, (byte) 0x45, (byte) 0xC2, (byte) 0x00, (byte) 0x45, (byte) 0x5D,
            (byte) 0xA1, (byte) 0x3E, (byte) 0xFD, (byte) 0x8D, (byte) 0x20, (byte) 0x97, (byte) 0xF6, (byte) 0x01,
            (byte) 0xFF, (byte) 0x8D, (byte) 0xDD, (byte) 0xB9, (byte) 0x97, (byte) 0x36, (byte) 0x47, (byte) 0x8B,
            (byte) 0x90, (byte) 0x83, (byte) 0x0F, (byte) 0x6B, (byte) 0x98, (byte) 0xAF, (byte) 0xB7, (byte) 0x3F,
            (byte) 0x0B, (byte) 0x9D, (byte) 0xC1, (byte) 0x29, (byte) 0xDD, (byte) 0x17, (byte) 0x4C, (byte) 0x73,
            (byte) 0xAC, (byte) 0xA7, (byte) 0xB7, (byte) 0xDD, (byte) 0xF7, (byte) 0x89, (byte) 0x87, (byte) 0x38,
            (byte) 0x47, (byte) 0xD6, (byte) 0x59, (byte) 0xC9, (byte) 0xC9, (byte) 0xE7, (byte) 0x47, (byte) 0xCD,
            (byte) 0x91, (byte) 0xFB, (byte) 0xC7, (byte) 0xF6, (byte) 0xF6, (byte) 0xB4, (byte) 0x74, (byte) 0xF9,
            (byte) 0xAE, (byte) 0x64, (byte) 0xD9, (byte) 0xF5, (byte) 0x57, (byte) 0x72, (byte) 0x49, (byte) 0x7A,
            (byte) 0x9A, (byte) 0xE4, (byte) 0x90, (byte) 0x40, (byte) 0x66, (byte) 0xB8, (byte) 0x4B, (byte) 0xE6,
            (byte) 0x85, (byte) 0xAC, (byte) 0x43, (byte) 0x66, (byte) 0xB2, (byte) 0xD4, (byte) 0x4D, (byte) 0xA7,
            (byte) 0x89, (byte) 0x6E, (byte) 0x22, (byte) 0x0E, (byte) 0x92, (byte) 0x8E, (byte) 0x24, (byte) 0x49,
            (byte) 0xA1, (byte) 0xEE, (byte) 0x35, (byte) 0x80, (byte) 0xD8, (byte) 0x93, (byte) 0x43, (byte) 0x0F,
            (byte) 0x87, (byte) 0x2D, (byte) 0x56, (byte) 0xBB, (byte) 0xC5, (byte) 0x42, (byte) 0xFF, (byte) 0xB5,
            (byte) 0xED, (byte) 0x13, (byte) 0xFB, (byte) 0x7D, (byte) 0x25, (byte) 0xDF, (byte) 0x42, (byte) 0x82,
            (byte) 0xA6, (byte) 0xFE, (byte) 0x7E, (byte) 0x18, (byte) 0x08, (byte) 0x69, (byte) 0x42, (byte) 0xB3,
            (byte) 0x50, (byte) 0x14, (byte) 0x0F, (byte) 0x62, (byte) 0x21, (byte) 0x58, (byte) 0x48, (byte) 0x08,
            (byte) 0xAD, (byte) 0x4A, (byte) 0xC6, (byte) 0xFC, (byte) 0xCC, (byte) 0x23, (byte) 0x3C, (byte) 0x39,
            (byte) 0xF3, (byte) 0x92, (byte) 0xD4, (byte) 0x94, (byte) 0x75, (byte) 0x8C, (byte) 0x47, (byte) 0xC4,
            (byte) 0x9B, (byte) 0xB5, (byte) 0xEB, (byte) 0xA8, (byte) 0x15, (byte) 0x90, (byte) 0xDA, (byte) 0x78,
            (byte) 0x0F, (byte) 0x6D, (byte) 0x82, (byte) 0x41, (byte) 0x6A, (byte) 0xC8, (byte) 0x48, (byte) 0x6F,
            (byte) 0x8C, (byte) 0x48, (byte) 0x67, (byte) 0x8A, (byte) 0x77, (byte) 0xA2, (byte) 0xDF, (byte) 0xF9,
            (byte) 0x3B, (byte) 0x0F, (byte) 0xF8, (byte) 0x61, (byte) 0x6C, (byte) 0x99, (byte) 0x4C, (byte) 0xE3,
            (byte) 0xA5, (byte) 0x66, (byte) 0xF7, (byte) 0x7A, (byte) 0x40, (byte) 0x1B, (byte) 0xCE, (byte) 0xAD,
            (byte) 0xCE, (byte) 0xB9, (byte) 0xE7, (byte) 0x88, (byte) 0x33, (byte) 0x5C, (byte) 0x47, (byte) 0x2D,
            (byte) 0x8F, (byte) 0x36, (byte) 0x9A, (byte) 0x1E, (byte) 0xE3, (byte) 0x73, (byte) 0xC2, (byte) 0x3A,
            (byte) 0xAA, (byte) 0x4D, (byte) 0x3B, (byte) 0x8F, (byte) 0x97, (byte) 0x8F, (byte) 0x4D, (byte) 0x83,
            (byte) 0x9A, (byte) 0x80, (byte) 0xBA, (byte) 0x27, (byte) 0x6D, (byte) 0x6D, (byte) 0x1C, (byte) 0x37,
            (byte) 0x6A, (byte) 0x27, (byte) 0x46, (byte) 0x62, (byte) 0x2D, (byte) 0xAF, (byte) 0x45, (byte) 0x7C,
            (byte) 0xB8, (byte) 0x6E, (byte) 0xC2, (byte) 0xB5, (byte) 0xEF, (byte) 0x7B, (byte) 0x65, (byte) 0x0B,
            (byte) 0x58, (byte) 0xAD, (byte) 0xF6, (byte) 0x99, (byte) 0x2A, (byte) 0x26, (byte) 0x48, (byte) 0x29,
            (byte) 0xBE, (byte) 0xF5, (byte) 0xF1, (byte) 0xC3, (byte) 0xE9, (byte) 0xAF, (byte) 0x3F, (byte) 0x24,
            (byte) 0x04, (byte) 0xEE, (byte) 0xA8, (byte) 0x76, (byte) 0x43, (byte) 0xD8, (byte) 0x41, (byte) 0x83,
            (byte) 0x98, (byte) 0x0E, (byte) 0x25, (byte) 0xFA, (byte) 0xF7, (byte) 0x39, (byte) 0xE4, (byte) 0x1C,
            (byte) 0xED, (byte) 0x0A, (byte) 0xF7, (byte) 0xE0, (byte) 0x9F, (byte) 0x8B, (byte) 0x48, (byte) 0xE4,
            (byte) 0x91, (byte) 0xB0, (byte) 0x1B, (byte) 0xCF, (byte) 0xCC, (byte) 0x39, (byte) 0xED, (byte) 0x24,
            (byte) 0x27, (byte) 0x43, (byte) 0x36, (byte) 0x53, (byte) 0xC4, (byte) 0xB7, (byte) 0x49, (byte) 0x40,
            (byte) 0x99, (byte) 0x62, (byte) 0x10, (byte) 0x0F, (byte) 0x4B, (byte) 0xAC, (byte) 0x6D, (byte) 0xAD,
            (byte) 0xC2, (byte) 0x44, (byte) 0x11, (byte) 0xCF, (byte) 0x84, (byte) 0x82, (byte) 0x4B, (byte) 0xA8,
            (byte) 0xA0, (byte) 0xAF, (byte) 0x89, (byte) 0xF5, (byte) 0xC3, (byte) 0x10, (byte) 0x57, (byte) 0xFF,
            (byte) 0xE4, (byte) 0x79, (byte) 0xFE, (byte) 0x80, (byte) 0x90, (byte) 0x18, (byte) 0x4C, (byte) 0xC5,
            (byte) 0x97, (byte) 0x0D, (byte) 0x1D, (byte) 0x70, (byte) 0x2A, (byte) 0x19, (byte) 0x79, (byte) 0x67,
            (byte) 0x62, (byte) 0x45, (byte) 0xBF, (byte) 0x53, (byte) 0x2C, (byte) 0x7C, (byte) 0x4C, (byte) 0xE5,
            (byte) 0x8B, (byte) 0x44, (byte) 0xC3, (byte) 0x1A, (byte) 0xC7, (byte) 0x83, (byte) 0x5E, (byte) 0x1D
    };

    public static final String PACK_FORMAT_ARCHIVE = "archive";
    public static final String PACK_FORMAT_RAW = "raw";
    public static final String PACK_FORMAT_FS= "fs";

    public static final int BINARY_ENRICHED_METADATA_SECTOR_1_ALIGNMENT_PADDING = 11 + 48;
    public static final int BINARY_ENRICHED_METADATA_TITLE_TRUNCATE = 64;           // 64 characters == 128 bytes
    public static final int BINARY_ENRICHED_METADATA_DESCRIPTION_TRUNCATE = 128;    // 128 characters == 256 bytes
    public static final int BINARY_ENRICHED_METADATA_STAGE_NODE_ALIGNMENT_PADDING = 10 + 48;
    public static final int BINARY_ENRICHED_METADATA_ACTION_NODE_ALIGNMENT = 16;
    public static final int BINARY_ENRICHED_METADATA_ACTION_NODE_ALIGNMENT_PADDING = 48;
    public static final int BINARY_ENRICHED_METADATA_NODE_NAME_TRUNCATE = 64;       // 64 characters == 128 bytes
}
