# OpenBible
[![GitHub Downloads (all assets, all releases)](https://img.shields.io/github/downloads/SchweGELBin/OpenBible2/total)](https://github.com/SchweGELBin/OpenBible2/releases)
[![GitHub License](https://img.shields.io/github/license/SchweGELBin/OpenBible2)](../LICENSE)
[![GitHub Release](https://img.shields.io/github/v/release/SchweGELBin/OpenBible2)](https://github.com/SchweGELBin/OpenBible2/releases/latest)
[![IzzyOnDroid Release](https://img.shields.io/endpoint?url=https://apt.izzysoft.de/fdroid/api/v1/shield/com.schwegelbin.openbible)](https://apt.izzysoft.de/packages/com.schwegelbin.openbible)
[![F-Droid Release](https://img.shields.io/f-droid/v/com.schwegelbin.openbible)](https://f-droid.org/packages/com.schwegelbin.openbible)

[<img src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png" height="60">](https://play.google.com/store/apps/details?id=com.schwegelbin.openbible)
[<img src="https://raw.githubusercontent.com/SchweGELBin/artwork/refs/heads/main/badges/get-it-on-github.png" height="60">](https://github.com/SchweGELBin/OpenBible2/releases/latest)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" height="60">](https://apt.izzysoft.de/packages/com.schwegelbin.openbible)
[<img src="https://f-droid.org/badge/get-it-on.png" height="60">](https://f-droid.org/packages/com.schwegelbin.openbible)

[German](./README_DE.md)

<!-- ../metadata/en-US/short_description.txt -->
OpenBible provides the Bible with as little distractions as possible

## Description
<!-- ../metadata/en-US/full_description.txt -->
OpenBible aims to be an open, simple and lightweight Android application for reading the Bible without any additional inputs. This means that the app contains only the Bible without items like section headings, comments, reading plans or tips.

OpenBible allows you to download the Bible in many different languages and translations. It strives to keep these translations up to date to address formatting or similar issues.
You can select the translation, book and chapter or find verses by searching their content.
The app lets you customize your reading experience through color themes, color schemes, text alignment, split screen mode, font size and verse number visibility.
These settings default to your system preferences to reduce the need for manual adjustments.
While reading, you can pinch or double click the screen to temporarily change the font size. Additionally, you can select text to copy or share it.
Your settings, selections and translations are saved and can be backed up for convenience.

## How does it work?
It is written in [Jetpack Compose](https://developer.android.com/compose) and uses [Material You](https://m3.material.io) as its Design.
Scripture data is being provided by [getBible](https://getbible.life/docs), a recognized [front end](https://wiki.crosswire.org/Frontends:getBible) for Crosswire’s SWORD modules.

## Screenshots
| ![](../metadata/en-US/images/phoneScreenshots/1.png) | ![](../metadata/en-US/images/phoneScreenshots/2.png) | ![](../metadata/en-US/images/phoneScreenshots/3.png) |
|------------------------------------------------------|------------------------------------------------------|------------------------------------------------------|
