-- API specification for graph.lua module
-- Maps each exported symbol to the API level where it was introduced
-- All existing APIs are level 1
return {
	-- Enums
	GRAPH_TYPE = 1,
	["GRAPH_TYPE.DATA_POINT"] = 1,
	["GRAPH_TYPE.TEXT"] = 1,
	["GRAPH_TYPE.PIE_CHART"] = 1,
	["GRAPH_TYPE.TIME_BARCHART"] = 1,
	["GRAPH_TYPE.LINE_GRAPH"] = 1,

	LINE_POINT_STYLE = 1,
	["LINE_POINT_STYLE.NONE"] = 1,
	["LINE_POINT_STYLE.CIRCLE"] = 1,
	["LINE_POINT_STYLE.CIRCLE_VALUE"] = 1,
	["LINE_POINT_STYLE.CIRCLE_ONLY"] = 1,

	-- Functions
	data_point = 1,
	text = 1,
	pie_chart = 1,
	line_graph = 1,
	time_barchart = 1,

	-- Type stubs
	DataPointGraphParams = 1,
	TextGraphParams = 1,
	PieChartGraphParams = 1,
	LineGraphParams = 1,
	TimeBarChartGraphParams = 1,
	PieChartSegment = 1,
	TimeBarChartSegment = 1,
	RangeBounds = 1,
	Line = 1,
	LinePoint = 1,
}
