return {
  functions={
    {
      id="filter-by-label",
      script="-- Example Lua Function with Input Count and Configuration\n-- This function filters data points by label\n\nlocal function match(data_point, filter_label, case_sensitive, match_exactly)\n    if filter_label == nil then\n        return true\n    end\n\n    local data_label = data_point.label\n    if not data_label then return false end\n\n    -- Apply case sensitivity\n    if not case_sensitive then\n        data_label = string.lower(data_label)\n        filter_label = string.lower(filter_label)\n    end\n\n    -- Apply matching mode\n    if match_exactly then\n        return data_label == filter_label\n    else\n        return string.find(data_label, filter_label, 1, true) ~= nil\n    end\nend\n\n\nreturn {\n    -- Configuration metadata\n    id = \"filter-by-label\",\n    version = \"1.0.0\",\n    inputCount = 1,\n    categories = {\"filter\"},\n    title = {\n        [\"en\"] = \"Filter by Label\",\n        [\"de\"] = \"Filtern nach Etikett\",\n        [\"es\"] = \"Filtrar por Etiqueta\",\n        [\"fr\"] = \"Filtrer par Étiquette\"\n    },\n    description = {\n        [\"en\"] = [[Filters data points by their label field. Only data points matching the filter criteria will pass through.\n\nConfiguration:\n• Filter Label: The text to search for in labels\n• Case Sensitive: Match case exactly (default: false)\n• Match Exactly: Require exact match instead of substring (default: false)\n• Invert: Keep data points that DON'T match instead (default: false)]],\n        [\"de\"] = [[Filtert Datenpunkte nach ihrem Label-Feld. Nur Datenpunkte, die den Filterkriterien entsprechen, werden durchgelassen.\n\nKonfiguration:\n• Filter-Label: Der Text, nach dem in Labels gesucht werden soll\n• Groß-/Kleinschreibung beachten: Groß-/Kleinschreibung exakt beachten (Standard: false)\n• Exakt übereinstimmen: Exakte Übereinstimmung statt Teilstring erforderlich (Standard: false)\n• Invertieren: Datenpunkte behalten, die NICHT übereinstimmen (Standard: false)]],\n        [\"es\"] = [[Filtra puntos de datos por su campo de etiqueta. Solo los puntos de datos que coincidan con los criterios del filtro pasarán.\n\nConfiguración:\n• Filtrar Etiqueta: El texto a buscar en las etiquetas\n• Sensible a Mayúsculas: Coincidir exactamente con mayúsculas y minúsculas (predeterminado: false)\n• Coincidir Exactamente: Requerir coincidencia exacta en lugar de subcadena (predeterminado: false)\n• Invertir: Mantener puntos de datos que NO coincidan (predeterminado: false)]],\n        [\"fr\"] = [[Filtre les points de données par leur champ d'étiquette. Seuls les points de données correspondant aux critères du filtre passeront.\n\nConfiguration:\n• Filtrer l'Étiquette: Le texte à rechercher dans les étiquettes\n• Sensible à la Casse: Correspondance exacte de la casse (par défaut: false)\n• Correspondance Exacte: Nécessite une correspondance exacte au lieu d'une sous-chaîne (par défaut: false)\n• Inverser: Conserver les points de données qui NE correspondent PAS (par défaut: false)]]\n    },\n    config = {\n        {\n            id = \"filter_label\",\n            type = \"text\",\n            name = {\n                [\"en\"] = \"Filter Label\",\n                [\"de\"] = \"Filter-Label\",\n                [\"es\"] = \"Filtrar Etiqueta\",\n                [\"fr\"] = \"Filtrer l'Étiquette\"\n            }\n        },\n        {\n            id = \"case_sensitive\",\n            type = \"checkbox\",\n            name = {\n                [\"en\"] = \"Case Sensitive\",\n                [\"de\"] = \"Groß-/Kleinschreibung beachten\",\n                [\"es\"] = \"Sensible a Mayúsculas\",\n                [\"fr\"] = \"Sensible à la Casse\"\n            }\n        },\n        {\n            id = \"match_exactly\",\n            type = \"checkbox\",\n            name = {\n                [\"en\"] = \"Match Exactly\",\n                [\"de\"] = \"Exakt übereinstimmen\",\n                [\"es\"] = \"Coincidir Exactamente\",\n                [\"fr\"] = \"Correspondance Exacte\"\n            }\n        },\n        {\n            id = \"invert\",\n            type = \"checkbox\",\n            name = {\n                [\"en\"] = \"Invert\",\n                [\"de\"] = \"Invertieren\",\n                [\"es\"] = \"Invertir\",\n                [\"fr\"] = \"Inverser\"\n            }\n        }\n    },\n\n    -- Generator function\n    generator = function(source, config)\n        local filter_label = config and config.filter_label\n        local case_sensitive = config and config.case_sensitive or false\n        local match_exactly = config and config.match_exactly or false\n        local invert = config and config.invert or false\n\n        return function()\n            local data_point = source.dp()\n            local should_match = not invert\n            while data_point and (match(data_point, filter_label, case_sensitive, match_exactly) ~= should_match) do\n                data_point = source.dp()\n            end\n            return data_point\n        end\n    end\n}\n",
      version="1.0.0"
    },
    {
      id="multiply",
      script="-- Lua Function to multiply data point values by a configurable number\n-- This function multiplies all incoming data point values by a specified multiplier\n\nreturn {\n    -- Configuration metadata\n    id = \"multiply\",\n    version = \"1.0.0\",\n    inputCount = 1,\n    categories = {\"arithmetic\"},\n    title = {\n        [\"en\"] = \"Multiply Values\",\n        [\"de\"] = \"Werte multiplizieren\",\n        [\"es\"] = \"Multiplicar Valores\",\n        [\"fr\"] = \"Multiplier les Valeurs\"\n    },\n    description = {\n        [\"en\"] = [[Multiplies all incoming data point values by a specified multiplier.\n\nConfiguration:\n• Multiplier: The number to multiply all values by (default: 1.0)]],\n        [\"de\"] = [[Multipliziert alle eingehenden Datenpunktwerte mit einem bestimmten Multiplikator.\n\nKonfiguration:\n• Multiplikator: Die Zahl, mit der alle Werte multipliziert werden (Standard: 1.0)]],\n        [\"es\"] = [[Multiplica todos los valores de puntos de datos entrantes por un multiplicador especificado.\n\nConfiguración:\n• Multiplicador: El número por el cual multiplicar todos los valores (predeterminado: 1.0)]],\n        [\"fr\"] = [[Multiplie toutes les valeurs de points de données entrantes par un multiplicateur spécifié.\n\nConfiguration:\n• Multiplicateur: Le nombre par lequel multiplier toutes les valeurs (par défaut: 1.0)]]\n    },\n    config = {\n        {\n            id = \"multiplier\",\n            type = \"number\",\n            name = {\n                [\"en\"] = \"Multiplier\",\n                [\"de\"] = \"Multiplikator\",\n                [\"es\"] = \"Multiplicador\",\n                [\"fr\"] = \"Multiplicateur\"\n            }\n        }\n    },\n\n    -- Generator function\n    generator = function(source, config)\n        local multiplier = config and config.multiplier or 1.0\n\n        return function()\n            local data_point = source.dp()\n            if not data_point then return nil end\n\n            data_point.value = data_point.value * multiplier\n\n            return data_point\n        end\n    end\n}\n",
      version="1.0.0"
    },
    {
      id="override-label",
      script="-- Lua Function to override the label of all data points with a configurable string\n-- This function sets all incoming data point labels to a specified value\n\nreturn {\n    -- Configuration metadata\n    id = \"override-label\",\n    version = \"1.0.0\",\n    inputCount = 1,\n    categories = {\"transform\"},\n    title = {\n        [\"en\"] = \"Override Label\",\n        [\"de\"] = \"Label überschreiben\",\n        [\"es\"] = \"Sobrescribir Etiqueta\",\n        [\"fr\"] = \"Remplacer l'Étiquette\",\n    },\n    description = {\n        [\"en\"] = \"Sets all incoming data point labels to a specified value\",\n        [\"de\"] = \"Setzt alle eingehenden Datenpunkt-Labels auf einen bestimmten Wert\",\n        [\"es\"] = \"Establece todas las etiquetas de puntos de datos entrantes en un valor especificado\",\n        [\"fr\"] = \"Définit toutes les étiquettes de points de données entrantes sur une valeur spécifiée\",\n    },\n    config = {\n        {\n            id = \"new_label\",\n            type = \"text\",\n            name = {\n                [\"en\"] = \"New Label\",\n                [\"de\"] = \"Neues Label\",\n                [\"es\"] = \"Nueva Etiqueta\",\n                [\"fr\"] = \"Nouvelle Étiquette\",\n            },\n        },\n    },\n\n    -- Generator function\n    generator = function(source, config)\n        local new_label = config and config.new_label\n\n        return function()\n            local data_point = source.dp()\n            if not data_point then\n                return nil\n            end\n\n            if not new_label then\n                return data_point\n            end\n            data_point.label = new_label\n\n            return data_point\n        end\n    end,\n}\n",
      version="1.0.0"
    }
  },
  published_at="2025-10-15T21:46:04Z"
}
