return {
  functions={
    {
      id="filter-by-label",
      script="-- Example Lua Function with Input Count and Configuration\n-- This function filters data points by label\n\nlocal function match(data_point, filter_label, case_sensitive, match_exactly)\n    if filter_label == nil then\n        return true\n    end\n\n    local data_label = data_point.label\n    if not data_label then return false end\n\n    -- Apply case sensitivity\n    if not case_sensitive then\n        data_label = string.lower(data_label)\n        filter_label = string.lower(filter_label)\n    end\n\n    -- Apply matching mode\n    if match_exactly then\n        return data_label == filter_label\n    else\n        return string.find(data_label, filter_label, 1, true) ~= nil\n    end\nend\n\n\nreturn {\n    -- Configuration metadata\n    id = \"filter-by-label\",\n    version = \"1.0.0\",\n    inputCount = 1,\n    title = {\n        [\"en\"] = \"Filter by Label\",\n        [\"de\"] = \"Filtern nach Etikett\",\n        [\"es\"] = \"Filtrar por Etiqueta\",\n        [\"fr\"] = \"Filtrer par Étiquette\"\n    },\n    description = {\n        [\"en\"] = \"Filters data points by label with optional case sensitivity and exact matching\",\n        [\"de\"] = \"Filtert Datenpunkte nach Label mit optionaler Groß-/Kleinschreibung und exakter Übereinstimmung\",\n        [\"es\"] = \"Filtra puntos de datos por etiqueta con sensibilidad opcional a mayúsculas y coincidencia exacta\",\n        [\"fr\"] = \"Filtre les points de données par étiquette avec sensibilité à la casse et correspondance exacte facultatives\"\n    },\n    config = {\n        {\n            id = \"filter_label\",\n            type = \"text\",\n            name = {\n                [\"en\"] = \"Filter Label\",\n                [\"de\"] = \"Filter-Label\",\n                [\"es\"] = \"Filtrar Etiqueta\",\n                [\"fr\"] = \"Filtrer l'Étiquette\"\n            }\n        },\n        {\n            id = \"case_sensitive\",\n            type = \"checkbox\",\n            name = {\n                [\"en\"] = \"Case Sensitive\",\n                [\"de\"] = \"Groß-/Kleinschreibung beachten\",\n                [\"es\"] = \"Sensible a Mayúsculas\",\n                [\"fr\"] = \"Sensible à la Casse\"\n            }\n        },\n        {\n            id = \"match_exactly\",\n            type = \"checkbox\",\n            name = {\n                [\"en\"] = \"Match Exactly\",\n                [\"de\"] = \"Exakt übereinstimmen\",\n                [\"es\"] = \"Coincidir Exactamente\",\n                [\"fr\"] = \"Correspondance Exacte\"\n            }\n        }\n    },\n\n    -- Generator function\n    generator = function(source, config)\n        local filter_label = config and config.filter_label\n        local case_sensitive = config and config.case_sensitive or false\n        local match_exactly = config and config.match_exactly or false\n\n        return function()\n            local data_point = source.dp()\n            while data_point and not match(data_point, filter_label, case_sensitive, match_exactly) do\n                data_point = source.dp()\n            end\n            return data_point\n        end\n    end\n}\n",
      version="1.0.0"
    },
    {
      id="multiply",
      script="-- Lua Function to multiply data point values by a configurable number\n-- This function multiplies all incoming data point values by a specified multiplier\n\nreturn {\n    -- Configuration metadata\n    id = \"multiply\",\n    version = \"1.0.0\",\n    inputCount = 1,\n    title = {\n        [\"en\"] = \"Multiply Values\",\n        [\"de\"] = \"Werte multiplizieren\",\n        [\"es\"] = \"Multiplicar Valores\",\n        [\"fr\"] = \"Multiplier les Valeurs\"\n    },\n    description = {\n        [\"en\"] = \"Multiplies all incoming data point values by a specified multiplier\",\n        [\"de\"] = \"Multipliziert alle eingehenden Datenpunktwerte mit einem bestimmten Multiplikator\",\n        [\"es\"] = \"Multiplica todos los valores de puntos de datos entrantes por un multiplicador especificado\",\n        [\"fr\"] = \"Multiplie toutes les valeurs de points de données entrantes par un multiplicateur spécifié\"\n    },\n    config = {\n        {\n            id = \"multiplier\",\n            type = \"number\",\n            name = {\n                [\"en\"] = \"Multiplier\",\n                [\"de\"] = \"Multiplikator\",\n                [\"es\"] = \"Multiplicador\",\n                [\"fr\"] = \"Multiplicateur\"\n            }\n        }\n    },\n\n    -- Generator function\n    generator = function(source, config)\n        local multiplier = config and config.multiplier or 1.0\n\n        return function()\n            local data_point = source.dp()\n            if not data_point then return nil end\n\n            data_point.value = data_point.value * multiplier\n\n            return data_point\n        end\n    end\n}\n",
      version="1.0.0"
    },
    {
      id="override-label",
      script="-- Lua Function to override the label of all data points with a configurable string\n-- This function sets all incoming data point labels to a specified value\n\nreturn {\n    -- Configuration metadata\n    id = \"override-label\",\n    version = \"1.0.0\",\n    inputCount = 1,\n    title = {\n        [\"en\"] = \"Override Label\",\n        [\"de\"] = \"Label überschreiben\",\n        [\"es\"] = \"Sobrescribir Etiqueta\",\n        [\"fr\"] = \"Remplacer l'Étiquette\"\n    },\n    description = {\n        [\"en\"] = \"Sets all incoming data point labels to a specified value\",\n        [\"de\"] = \"Setzt alle eingehenden Datenpunkt-Labels auf einen bestimmten Wert\",\n        [\"es\"] = \"Establece todas las etiquetas de puntos de datos entrantes en un valor especificado\",\n        [\"fr\"] = \"Définit toutes les étiquettes de points de données entrantes sur une valeur spécifiée\"\n    },\n    config = {\n        {\n            id = \"new_label\",\n            type = \"text\",\n            name = {\n                [\"en\"] = \"New Label\",\n                [\"de\"] = \"Neues Label\",\n                [\"es\"] = \"Nueva Etiqueta\",\n                [\"fr\"] = \"Nouvelle Étiquette\"\n            }\n        }\n    },\n\n    -- Generator function\n    generator = function(source, config)\n        local new_label = config and config.new_label\n\n        return function()\n            local data_point = source.dp()\n            if not data_point then return nil end\n\n            if not new_label then return data_point end\n            data_point.label = new_label\n\n            return data_point\n        end\n    end\n}\n",
      version="1.0.0"
    }
  },
  published_at="2025-10-08T22:51:08Z"
}