/*
 *  This file is part of Track & Graph
 *
 *  Track & Graph is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Track & Graph is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Track & Graph.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.samco.trackandgraph.graphstatview.functions.data_sample_functions

import com.samco.trackandgraph.data.sampling.DataSample
import com.samco.trackandgraph.graphstatview.functions.aggregation.MovingAggregator
import com.samco.trackandgraph.graphstatview.functions.aggregation.averageDataPoints
import com.samco.trackandgraph.graphstatview.functions.aggregation.dataPointsLabel
import org.threeten.bp.Duration

/**
 * Calculate the moving averages of all of the data points given over the moving average duration given.
 * A new DataSample will be returned with one data point for every data point in the input set whose
 * timestamp shall be the same but value will be equal to the average of it and all previous data points
 * within the movingAvDuration.
 *
 * The data points in the input sample are expected to be in date order with the oldest data points
 * earliest in the list
 */
class MovingAverageFunction(
    private val movingAvgDuration: Duration
) : DataSampleFunction {
    override suspend fun mapSample(dataSample: DataSample) =
        MovingAggregator(movingAvgDuration, ::averageDataPoints, ::dataPointsLabel)
            .mapSample(dataSample)
}