package com.sakethh.linkora.domain.model

import com.sakethh.linkora.domain.model.link.Link
import com.sakethh.linkora.domain.model.panel.Panel
import com.sakethh.linkora.domain.model.panel.PanelFolder
import com.sakethh.linkora.domain.model.tag.LinkTag
import com.sakethh.linkora.domain.model.tag.Tag
import kotlinx.serialization.Serializable

@Serializable
data class JSONExportSchema(
    val schemaVersion: Int,
    val links: List<Link>,
    val folders: List<Folder>,
    val panels: PanelForJSONExportSchema,
    val tags: List<Tag> = emptyList(),
    val linkTags: List<LinkTag> = emptyList()
) {
    companion object {
        const val VERSION = 13
    }
}

@Serializable
data class PanelForJSONExportSchema(
    val panels: List<Panel>, val panelFolders: List<PanelFolder>
)
