/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.Rad: ImageVector
  get() {
    if (_rad != null) {
      return _rad!!
    }
    _rad =
      Builder(
          name = "Rad",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(4.7777f, 11.9737f)
            curveTo(5.0577f, 11.9737f, 5.3044f, 11.9404f, 5.5177f, 11.8737f)
            curveTo(5.7344f, 11.8037f, 5.9144f, 11.707f, 6.0577f, 11.5837f)
            curveTo(6.2044f, 11.457f, 6.3144f, 11.307f, 6.3877f, 11.1337f)
            curveTo(6.4611f, 10.9604f, 6.4977f, 10.7687f, 6.4977f, 10.5587f)
            curveTo(6.4977f, 10.132f, 6.3577f, 9.8104f, 6.0777f, 9.5937f)
            curveTo(5.7977f, 9.377f, 5.3777f, 9.2687f, 4.8177f, 9.2687f)
            horizontalLineTo(3.7577f)
            verticalLineTo(11.9737f)
            horizontalLineTo(4.7777f)
            close()
            moveTo(8.0877f, 15.6687f)
            horizontalLineTo(7.2277f)
            curveTo(7.0511f, 15.6687f, 6.9211f, 15.6004f, 6.8377f, 15.4637f)
            lineTo(4.9777f, 12.9037f)
            curveTo(4.9211f, 12.8237f, 4.8594f, 12.767f, 4.7927f, 12.7337f)
            curveTo(4.7294f, 12.697f, 4.6294f, 12.6787f, 4.4927f, 12.6787f)
            horizontalLineTo(3.7577f)
            verticalLineTo(15.6687f)
            horizontalLineTo(2.7927f)
            verticalLineTo(8.5037f)
            horizontalLineTo(4.8177f)
            curveTo(5.2711f, 8.5037f, 5.6627f, 8.5504f, 5.9927f, 8.6437f)
            curveTo(6.3227f, 8.7337f, 6.5944f, 8.8654f, 6.8077f, 9.0387f)
            curveTo(7.0244f, 9.212f, 7.1844f, 9.422f, 7.2877f, 9.6687f)
            curveTo(7.3911f, 9.912f, 7.4427f, 10.1854f, 7.4427f, 10.4887f)
            curveTo(7.4427f, 10.742f, 7.4027f, 10.9787f, 7.3227f, 11.1987f)
            curveTo(7.2427f, 11.4187f, 7.1261f, 11.617f, 6.9727f, 11.7937f)
            curveTo(6.8227f, 11.967f, 6.6377f, 12.1154f, 6.4177f, 12.2387f)
            curveTo(6.2011f, 12.362f, 5.9544f, 12.4554f, 5.6777f, 12.5187f)
            curveTo(5.8011f, 12.5887f, 5.9077f, 12.6904f, 5.9977f, 12.8237f)
            lineTo(8.0877f, 15.6687f)
            close()
            moveTo(12.6673f, 13.0087f)
            lineTo(11.5423f, 10.0937f)
            curveTo(11.5089f, 10.007f, 11.4739f, 9.907f, 11.4373f, 9.7937f)
            curveTo(11.4006f, 9.677f, 11.3656f, 9.5537f, 11.3323f, 9.4237f)
            curveTo(11.2623f, 9.6937f, 11.1906f, 9.9187f, 11.1173f, 10.0987f)
            lineTo(9.9923f, 13.0087f)
            horizontalLineTo(12.6673f)
            close()
            moveTo(14.6873f, 15.6687f)
            horizontalLineTo(13.9373f)
            curveTo(13.8506f, 15.6687f, 13.7806f, 15.647f, 13.7273f, 15.6037f)
            curveTo(13.6739f, 15.5604f, 13.6339f, 15.5054f, 13.6073f, 15.4387f)
            lineTo(12.9373f, 13.7087f)
            horizontalLineTo(9.7223f)
            lineTo(9.0523f, 15.4387f)
            curveTo(9.0323f, 15.4987f, 8.9939f, 15.552f, 8.9373f, 15.5987f)
            curveTo(8.8806f, 15.6454f, 8.8106f, 15.6687f, 8.7273f, 15.6687f)
            horizontalLineTo(7.9773f)
            lineTo(10.8423f, 8.5037f)
            horizontalLineTo(11.8223f)
            lineTo(14.6873f, 15.6687f)
            close()
            moveTo(21.6398f, 12.0887f)
            curveTo(21.6398f, 12.6254f, 21.5548f, 13.1137f, 21.3848f, 13.5537f)
            curveTo(21.2148f, 13.9937f, 20.9748f, 14.3704f, 20.6648f, 14.6837f)
            curveTo(20.3548f, 14.997f, 19.9815f, 15.2404f, 19.5448f, 15.4137f)
            curveTo(19.1115f, 15.5837f, 18.6315f, 15.6687f, 18.1048f, 15.6687f)
            horizontalLineTo(15.4298f)
            verticalLineTo(8.5037f)
            horizontalLineTo(18.1048f)
            curveTo(18.6315f, 8.5037f, 19.1115f, 8.5904f, 19.5448f, 8.7637f)
            curveTo(19.9815f, 8.9337f, 20.3548f, 9.177f, 20.6648f, 9.4937f)
            curveTo(20.9748f, 9.807f, 21.2148f, 10.1837f, 21.3848f, 10.6237f)
            curveTo(21.5548f, 11.0637f, 21.6398f, 11.552f, 21.6398f, 12.0887f)
            close()
            moveTo(20.6448f, 12.0887f)
            curveTo(20.6448f, 11.6487f, 20.5848f, 11.2554f, 20.4648f, 10.9087f)
            curveTo(20.3448f, 10.562f, 20.1748f, 10.2687f, 19.9548f, 10.0287f)
            curveTo(19.7348f, 9.7887f, 19.4682f, 9.6054f, 19.1548f, 9.4787f)
            curveTo(18.8415f, 9.352f, 18.4915f, 9.2887f, 18.1048f, 9.2887f)
            horizontalLineTo(16.3998f)
            verticalLineTo(14.8837f)
            horizontalLineTo(18.1048f)
            curveTo(18.4915f, 14.8837f, 18.8415f, 14.8204f, 19.1548f, 14.6937f)
            curveTo(19.4682f, 14.567f, 19.7348f, 14.3854f, 19.9548f, 14.1487f)
            curveTo(20.1748f, 13.9087f, 20.3448f, 13.6154f, 20.4648f, 13.2687f)
            curveTo(20.5848f, 12.922f, 20.6448f, 12.5287f, 20.6448f, 12.0887f)
            close()
          }
        }
        .build()
    return _rad!!
  }

private var _rad: ImageVector? = null
