/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.KeyC: ImageVector
  get() {
    if (_keyC != null) {
      return _keyC!!
    }
    _keyC =
      Builder(
          name = "KeyC",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(14.6052f, 14.1887f)
            curveTo(14.6585f, 14.1887f, 14.7052f, 14.2104f, 14.7452f, 14.2537f)
            lineTo(15.1302f, 14.6687f)
            curveTo(14.8368f, 15.0087f, 14.4802f, 15.2737f, 14.0602f, 15.4637f)
            curveTo(13.6435f, 15.6537f, 13.1385f, 15.7487f, 12.5452f, 15.7487f)
            curveTo(12.0318f, 15.7487f, 11.5652f, 15.6604f, 11.1452f, 15.4837f)
            curveTo(10.7252f, 15.3037f, 10.3668f, 15.0537f, 10.0702f, 14.7337f)
            curveTo(9.7735f, 14.4104f, 9.5435f, 14.0237f, 9.3802f, 13.5737f)
            curveTo(9.2168f, 13.1237f, 9.1352f, 12.6287f, 9.1352f, 12.0887f)
            curveTo(9.1352f, 11.5487f, 9.2202f, 11.0537f, 9.3902f, 10.6037f)
            curveTo(9.5602f, 10.1537f, 9.7985f, 9.767f, 10.1052f, 9.4437f)
            curveTo(10.4152f, 9.1204f, 10.7852f, 8.8704f, 11.2152f, 8.6937f)
            curveTo(11.6452f, 8.5137f, 12.1202f, 8.4237f, 12.6402f, 8.4237f)
            curveTo(13.1502f, 8.4237f, 13.6002f, 8.5054f, 13.9902f, 8.6687f)
            curveTo(14.3802f, 8.832f, 14.7235f, 9.0537f, 15.0202f, 9.3337f)
            lineTo(14.7002f, 9.7787f)
            curveTo(14.6802f, 9.812f, 14.6535f, 9.8404f, 14.6202f, 9.8637f)
            curveTo(14.5902f, 9.8837f, 14.5485f, 9.8937f, 14.4952f, 9.8937f)
            curveTo(14.4352f, 9.8937f, 14.3618f, 9.862f, 14.2752f, 9.7987f)
            curveTo(14.1885f, 9.732f, 14.0752f, 9.6587f, 13.9352f, 9.5787f)
            curveTo(13.7952f, 9.4987f, 13.6202f, 9.427f, 13.4102f, 9.3637f)
            curveTo(13.2002f, 9.297f, 12.9418f, 9.2637f, 12.6352f, 9.2637f)
            curveTo(12.2652f, 9.2637f, 11.9268f, 9.3287f, 11.6202f, 9.4587f)
            curveTo(11.3135f, 9.5854f, 11.0485f, 9.7704f, 10.8252f, 10.0137f)
            curveTo(10.6052f, 10.257f, 10.4335f, 10.5537f, 10.3102f, 10.9037f)
            curveTo(10.1868f, 11.2537f, 10.1252f, 11.6487f, 10.1252f, 12.0887f)
            curveTo(10.1252f, 12.5354f, 10.1885f, 12.9337f, 10.3152f, 13.2837f)
            curveTo(10.4452f, 13.6337f, 10.6202f, 13.9304f, 10.8402f, 14.1737f)
            curveTo(11.0635f, 14.4137f, 11.3252f, 14.597f, 11.6252f, 14.7237f)
            curveTo(11.9285f, 14.8504f, 12.2552f, 14.9137f, 12.6052f, 14.9137f)
            curveTo(12.8185f, 14.9137f, 13.0102f, 14.902f, 13.1802f, 14.8787f)
            curveTo(13.3535f, 14.852f, 13.5118f, 14.812f, 13.6552f, 14.7587f)
            curveTo(13.8018f, 14.7054f, 13.9368f, 14.6387f, 14.0602f, 14.5587f)
            curveTo(14.1868f, 14.4754f, 14.3118f, 14.377f, 14.4352f, 14.2637f)
            curveTo(14.4918f, 14.2137f, 14.5485f, 14.1887f, 14.6052f, 14.1887f)
            close()
          }
        }
        .build()
    return _keyC!!
  }

private var _keyC: ImageVector? = null
