/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.Key6: ImageVector
  get() {
    if (_key6 != null) {
      return _key6!!
    }
    _key6 =
      Builder(
          name = "Key6",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(11.9896f, 15.0087f)
            curveTo(12.2296f, 15.0087f, 12.4463f, 14.9704f, 12.6396f, 14.8937f)
            curveTo(12.8363f, 14.817f, 13.0029f, 14.7104f, 13.1396f, 14.5737f)
            curveTo(13.2796f, 14.437f, 13.3863f, 14.2754f, 13.4596f, 14.0887f)
            curveTo(13.5363f, 13.902f, 13.5746f, 13.6987f, 13.5746f, 13.4787f)
            curveTo(13.5746f, 13.2454f, 13.5379f, 13.0354f, 13.4646f, 12.8487f)
            curveTo(13.3913f, 12.6587f, 13.2863f, 12.4987f, 13.1496f, 12.3687f)
            curveTo(13.0163f, 12.2354f, 12.8563f, 12.1337f, 12.6696f, 12.0637f)
            curveTo(12.4829f, 11.9937f, 12.2779f, 11.9587f, 12.0546f, 11.9587f)
            curveTo(11.8146f, 11.9587f, 11.5979f, 12.0004f, 11.4046f, 12.0837f)
            curveTo(11.2113f, 12.1637f, 11.0463f, 12.2737f, 10.9096f, 12.4137f)
            curveTo(10.7763f, 12.5504f, 10.6729f, 12.7104f, 10.5996f, 12.8937f)
            curveTo(10.5296f, 13.0737f, 10.4946f, 13.262f, 10.4946f, 13.4587f)
            curveTo(10.4946f, 13.6887f, 10.5279f, 13.8987f, 10.5946f, 14.0887f)
            curveTo(10.6613f, 14.2787f, 10.7579f, 14.442f, 10.8846f, 14.5787f)
            curveTo(11.0146f, 14.7154f, 11.1713f, 14.822f, 11.3546f, 14.8987f)
            curveTo(11.5413f, 14.972f, 11.7529f, 15.0087f, 11.9896f, 15.0087f)
            close()
            moveTo(11.4696f, 11.1887f)
            curveTo(11.4063f, 11.2687f, 11.3446f, 11.347f, 11.2846f, 11.4237f)
            curveTo(11.2279f, 11.497f, 11.1729f, 11.5704f, 11.1196f, 11.6437f)
            curveTo(11.2896f, 11.527f, 11.4763f, 11.437f, 11.6796f, 11.3737f)
            curveTo(11.8829f, 11.3104f, 12.1046f, 11.2787f, 12.3446f, 11.2787f)
            curveTo(12.6346f, 11.2787f, 12.9079f, 11.327f, 13.1646f, 11.4237f)
            curveTo(13.4213f, 11.517f, 13.6446f, 11.6554f, 13.8346f, 11.8387f)
            curveTo(14.0279f, 12.0187f, 14.1813f, 12.242f, 14.2946f, 12.5087f)
            curveTo(14.4079f, 12.772f, 14.4646f, 13.0737f, 14.4646f, 13.4137f)
            curveTo(14.4646f, 13.7437f, 14.4046f, 14.0504f, 14.2846f, 14.3337f)
            curveTo(14.1646f, 14.617f, 13.9963f, 14.8637f, 13.7796f, 15.0737f)
            curveTo(13.5663f, 15.2837f, 13.3079f, 15.4487f, 13.0046f, 15.5687f)
            curveTo(12.7046f, 15.6887f, 12.3729f, 15.7487f, 12.0096f, 15.7487f)
            curveTo(11.6496f, 15.7487f, 11.3229f, 15.692f, 11.0296f, 15.5787f)
            curveTo(10.7363f, 15.462f, 10.4863f, 15.2987f, 10.2796f, 15.0887f)
            curveTo(10.0763f, 14.8754f, 9.9179f, 14.6187f, 9.8046f, 14.3187f)
            curveTo(9.6946f, 14.0154f, 9.6396f, 13.677f, 9.6396f, 13.3037f)
            curveTo(9.6396f, 12.9904f, 9.7079f, 12.657f, 9.8446f, 12.3037f)
            curveTo(9.9846f, 11.947f, 10.2063f, 11.567f, 10.5096f, 11.1637f)
            lineTo(12.3296f, 8.7187f)
            curveTo(12.3763f, 8.6587f, 12.4396f, 8.6087f, 12.5196f, 8.5687f)
            curveTo(12.6029f, 8.5254f, 12.6979f, 8.5037f, 12.8046f, 8.5037f)
            horizontalLineTo(13.5946f)
            lineTo(11.4696f, 11.1887f)
            close()
          }
        }
        .build()
    return _key6!!
  }

private var _key6: ImageVector? = null
