/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.Key5: ImageVector
  get() {
    if (_key5 != null) {
      return _key5!!
    }
    _key5 =
      Builder(
          name = "Key5",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(10.9096f, 11.2087f)
            curveTo(11.2829f, 11.1287f, 11.6263f, 11.0887f, 11.9396f, 11.0887f)
            curveTo(12.3129f, 11.0887f, 12.6429f, 11.1437f, 12.9296f, 11.2537f)
            curveTo(13.2163f, 11.3637f, 13.4546f, 11.5154f, 13.6446f, 11.7087f)
            curveTo(13.8379f, 11.902f, 13.9829f, 12.1304f, 14.0796f, 12.3937f)
            curveTo(14.1796f, 12.657f, 14.2296f, 12.9437f, 14.2296f, 13.2537f)
            curveTo(14.2296f, 13.6337f, 14.1629f, 13.977f, 14.0296f, 14.2837f)
            curveTo(13.8996f, 14.5904f, 13.7179f, 14.8537f, 13.4846f, 15.0737f)
            curveTo(13.2546f, 15.2904f, 12.9829f, 15.457f, 12.6696f, 15.5737f)
            curveTo(12.3563f, 15.6904f, 12.0179f, 15.7487f, 11.6546f, 15.7487f)
            curveTo(11.4446f, 15.7487f, 11.2429f, 15.727f, 11.0496f, 15.6837f)
            curveTo(10.8563f, 15.6437f, 10.6746f, 15.5887f, 10.5046f, 15.5187f)
            curveTo(10.3379f, 15.4487f, 10.1829f, 15.3687f, 10.0396f, 15.2787f)
            curveTo(9.8963f, 15.1887f, 9.7696f, 15.0937f, 9.6596f, 14.9937f)
            lineTo(9.9346f, 14.6137f)
            curveTo(9.9946f, 14.527f, 10.0729f, 14.4837f, 10.1696f, 14.4837f)
            curveTo(10.2363f, 14.4837f, 10.3113f, 14.5104f, 10.3946f, 14.5637f)
            curveTo(10.4779f, 14.6137f, 10.5796f, 14.6704f, 10.6996f, 14.7337f)
            curveTo(10.8196f, 14.797f, 10.9596f, 14.8554f, 11.1196f, 14.9087f)
            curveTo(11.2829f, 14.9587f, 11.4763f, 14.9837f, 11.6996f, 14.9837f)
            curveTo(11.9496f, 14.9837f, 12.1746f, 14.9437f, 12.3746f, 14.8637f)
            curveTo(12.5746f, 14.7837f, 12.7463f, 14.6704f, 12.8896f, 14.5237f)
            curveTo(13.0329f, 14.3737f, 13.1429f, 14.1954f, 13.2196f, 13.9887f)
            curveTo(13.2963f, 13.782f, 13.3346f, 13.5504f, 13.3346f, 13.2937f)
            curveTo(13.3346f, 13.0704f, 13.3013f, 12.8687f, 13.2346f, 12.6887f)
            curveTo(13.1713f, 12.5087f, 13.0729f, 12.3554f, 12.9396f, 12.2287f)
            curveTo(12.8096f, 12.102f, 12.6463f, 12.0037f, 12.4496f, 11.9337f)
            curveTo(12.2529f, 11.8637f, 12.0229f, 11.8287f, 11.7596f, 11.8287f)
            curveTo(11.5796f, 11.8287f, 11.3913f, 11.8437f, 11.1946f, 11.8737f)
            curveTo(11.0013f, 11.9037f, 10.8029f, 11.952f, 10.5996f, 12.0187f)
            lineTo(10.0396f, 11.8537f)
            lineTo(10.6146f, 8.5037f)
            horizontalLineTo(14.0096f)
            verticalLineTo(8.8937f)
            curveTo(14.0096f, 9.0204f, 13.9696f, 9.1254f, 13.8896f, 9.2087f)
            curveTo(13.8129f, 9.2887f, 13.6796f, 9.3287f, 13.4896f, 9.3287f)
            horizontalLineTo(11.2396f)
            lineTo(10.9096f, 11.2087f)
            close()
          }
        }
        .build()
    return _key5!!
  }

private var _key5: ImageVector? = null
