/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.Key0: ImageVector
  get() {
    if (_key0 != null) {
      return _key0!!
    }
    _key0 =
      Builder(
          name = "Key0",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(14.5996f, 12.0887f)
            curveTo(14.5996f, 12.7154f, 14.5313f, 13.2587f, 14.3946f, 13.7187f)
            curveTo(14.2613f, 14.1754f, 14.0779f, 14.5537f, 13.8446f, 14.8537f)
            curveTo(13.6113f, 15.1537f, 13.3346f, 15.377f, 13.0146f, 15.5237f)
            curveTo(12.6979f, 15.6704f, 12.3579f, 15.7437f, 11.9946f, 15.7437f)
            curveTo(11.6279f, 15.7437f, 11.2863f, 15.6704f, 10.9696f, 15.5237f)
            curveTo(10.6563f, 15.377f, 10.3829f, 15.1537f, 10.1496f, 14.8537f)
            curveTo(9.9163f, 14.5537f, 9.7329f, 14.1754f, 9.5996f, 13.7187f)
            curveTo(9.4663f, 13.2587f, 9.3996f, 12.7154f, 9.3996f, 12.0887f)
            curveTo(9.3996f, 11.462f, 9.4663f, 10.9187f, 9.5996f, 10.4587f)
            curveTo(9.7329f, 9.9987f, 9.9163f, 9.6187f, 10.1496f, 9.3187f)
            curveTo(10.3829f, 9.0154f, 10.6563f, 8.7904f, 10.9696f, 8.6437f)
            curveTo(11.2863f, 8.497f, 11.6279f, 8.4237f, 11.9946f, 8.4237f)
            curveTo(12.3579f, 8.4237f, 12.6979f, 8.497f, 13.0146f, 8.6437f)
            curveTo(13.3346f, 8.7904f, 13.6113f, 9.0154f, 13.8446f, 9.3187f)
            curveTo(14.0779f, 9.6187f, 14.2613f, 9.9987f, 14.3946f, 10.4587f)
            curveTo(14.5313f, 10.9187f, 14.5996f, 11.462f, 14.5996f, 12.0887f)
            close()
            moveTo(13.6746f, 12.0887f)
            curveTo(13.6746f, 11.542f, 13.6279f, 11.0837f, 13.5346f, 10.7137f)
            curveTo(13.4446f, 10.3404f, 13.3213f, 10.0404f, 13.1646f, 9.8137f)
            curveTo(13.0113f, 9.587f, 12.8329f, 9.4254f, 12.6296f, 9.3287f)
            curveTo(12.4263f, 9.2287f, 12.2146f, 9.1787f, 11.9946f, 9.1787f)
            curveTo(11.7746f, 9.1787f, 11.5629f, 9.2287f, 11.3596f, 9.3287f)
            curveTo(11.1563f, 9.4254f, 10.9779f, 9.587f, 10.8246f, 9.8137f)
            curveTo(10.6713f, 10.0404f, 10.5479f, 10.3404f, 10.4546f, 10.7137f)
            curveTo(10.3646f, 11.0837f, 10.3196f, 11.542f, 10.3196f, 12.0887f)
            curveTo(10.3196f, 12.6354f, 10.3646f, 13.0937f, 10.4546f, 13.4637f)
            curveTo(10.5479f, 13.8337f, 10.6713f, 14.132f, 10.8246f, 14.3587f)
            curveTo(10.9779f, 14.5854f, 11.1563f, 14.7487f, 11.3596f, 14.8487f)
            curveTo(11.5629f, 14.9454f, 11.7746f, 14.9937f, 11.9946f, 14.9937f)
            curveTo(12.2146f, 14.9937f, 12.4263f, 14.9454f, 12.6296f, 14.8487f)
            curveTo(12.8329f, 14.7487f, 13.0113f, 14.5854f, 13.1646f, 14.3587f)
            curveTo(13.3213f, 14.132f, 13.4446f, 13.8337f, 13.5346f, 13.4637f)
            curveTo(13.6279f, 13.0937f, 13.6746f, 12.6354f, 13.6746f, 12.0887f)
            close()
          }
        }
        .build()
    return _key0!!
  }

private var _key0: ImageVector? = null
