/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.Key3: ImageVector
  get() {
    if (_key3 != null) {
      return _key3!!
    }
    _key3 =
      Builder(
          name = "Key3",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(9.7496f, 10.4437f)
            curveTo(9.7963f, 10.117f, 9.8863f, 9.8287f, 10.0196f, 9.5787f)
            curveTo(10.1529f, 9.3254f, 10.3213f, 9.1137f, 10.5246f, 8.9437f)
            curveTo(10.7313f, 8.7737f, 10.9663f, 8.6454f, 11.2296f, 8.5587f)
            curveTo(11.4963f, 8.4687f, 11.7829f, 8.4237f, 12.0896f, 8.4237f)
            curveTo(12.3929f, 8.4237f, 12.6729f, 8.467f, 12.9296f, 8.5537f)
            curveTo(13.1863f, 8.6404f, 13.4063f, 8.7637f, 13.5896f, 8.9237f)
            curveTo(13.7763f, 9.0837f, 13.9213f, 9.277f, 14.0246f, 9.5037f)
            curveTo(14.1279f, 9.7304f, 14.1796f, 9.982f, 14.1796f, 10.2587f)
            curveTo(14.1796f, 10.4854f, 14.1496f, 10.6887f, 14.0896f, 10.8687f)
            curveTo(14.0329f, 11.0454f, 13.9496f, 11.2004f, 13.8396f, 11.3337f)
            curveTo(13.7329f, 11.467f, 13.6029f, 11.5804f, 13.4496f, 11.6737f)
            curveTo(13.2963f, 11.767f, 13.1246f, 11.8437f, 12.9346f, 11.9037f)
            curveTo(13.4013f, 12.0237f, 13.7513f, 12.2304f, 13.9846f, 12.5237f)
            curveTo(14.2213f, 12.8137f, 14.3396f, 13.177f, 14.3396f, 13.6137f)
            curveTo(14.3396f, 13.9437f, 14.2763f, 14.2404f, 14.1496f, 14.5037f)
            curveTo(14.0263f, 14.767f, 13.8563f, 14.992f, 13.6396f, 15.1787f)
            curveTo(13.4229f, 15.362f, 13.1696f, 15.5037f, 12.8796f, 15.6037f)
            curveTo(12.5929f, 15.7004f, 12.2846f, 15.7487f, 11.9546f, 15.7487f)
            curveTo(11.5746f, 15.7487f, 11.2496f, 15.702f, 10.9796f, 15.6087f)
            curveTo(10.7096f, 15.512f, 10.4813f, 15.3804f, 10.2946f, 15.2137f)
            curveTo(10.1079f, 15.047f, 9.9546f, 14.8504f, 9.8346f, 14.6237f)
            curveTo(9.7146f, 14.3937f, 9.6129f, 14.1454f, 9.5296f, 13.8787f)
            lineTo(9.9146f, 13.7187f)
            curveTo(10.0146f, 13.6754f, 10.1113f, 13.6637f, 10.2046f, 13.6837f)
            curveTo(10.3013f, 13.7037f, 10.3713f, 13.7587f, 10.4146f, 13.8487f)
            curveTo(10.4579f, 13.942f, 10.5113f, 14.0537f, 10.5746f, 14.1837f)
            curveTo(10.6413f, 14.3137f, 10.7313f, 14.4387f, 10.8446f, 14.5587f)
            curveTo(10.9579f, 14.6787f, 11.1013f, 14.7804f, 11.2746f, 14.8637f)
            curveTo(11.4513f, 14.947f, 11.6746f, 14.9887f, 11.9446f, 14.9887f)
            curveTo(12.1946f, 14.9887f, 12.4129f, 14.9487f, 12.5996f, 14.8687f)
            curveTo(12.7896f, 14.7854f, 12.9463f, 14.6787f, 13.0696f, 14.5487f)
            curveTo(13.1963f, 14.4187f, 13.2913f, 14.2737f, 13.3546f, 14.1137f)
            curveTo(13.4179f, 13.9537f, 13.4496f, 13.7954f, 13.4496f, 13.6387f)
            curveTo(13.4496f, 13.4454f, 13.4246f, 13.2687f, 13.3746f, 13.1087f)
            curveTo(13.3246f, 12.9487f, 13.2313f, 12.8104f, 13.0946f, 12.6937f)
            curveTo(12.9579f, 12.577f, 12.7696f, 12.4854f, 12.5296f, 12.4187f)
            curveTo(12.2929f, 12.352f, 11.9879f, 12.3187f, 11.6146f, 12.3187f)
            verticalLineTo(11.6737f)
            curveTo(11.9213f, 11.6704f, 12.1813f, 11.637f, 12.3946f, 11.5737f)
            curveTo(12.6113f, 11.5104f, 12.7863f, 11.4237f, 12.9196f, 11.3137f)
            curveTo(13.0563f, 11.2037f, 13.1546f, 11.072f, 13.2146f, 10.9187f)
            curveTo(13.2779f, 10.7654f, 13.3096f, 10.5954f, 13.3096f, 10.4087f)
            curveTo(13.3096f, 10.202f, 13.2763f, 10.022f, 13.2096f, 9.8687f)
            curveTo(13.1463f, 9.7154f, 13.0579f, 9.5887f, 12.9446f, 9.4887f)
            curveTo(12.8313f, 9.3887f, 12.6963f, 9.3137f, 12.5396f, 9.2637f)
            curveTo(12.3863f, 9.2137f, 12.2196f, 9.1887f, 12.0396f, 9.1887f)
            curveTo(11.8596f, 9.1887f, 11.6913f, 9.2154f, 11.5346f, 9.2687f)
            curveTo(11.3813f, 9.322f, 11.2446f, 9.397f, 11.1246f, 9.4937f)
            curveTo(11.0079f, 9.587f, 10.9096f, 9.6987f, 10.8296f, 9.8287f)
            curveTo(10.7496f, 9.9587f, 10.6929f, 10.102f, 10.6596f, 10.2587f)
            curveTo(10.6163f, 10.3754f, 10.5613f, 10.4537f, 10.4946f, 10.4937f)
            curveTo(10.4313f, 10.5304f, 10.3379f, 10.5404f, 10.2146f, 10.5237f)
            lineTo(9.7496f, 10.4437f)
            close()
          }
        }
        .build()
    return _key3!!
  }

private var _key3: ImageVector? = null
