/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.AcTan: ImageVector
  get() {
    if (_arTan != null) {
      return _arTan!!
    }
    _arTan =
      Builder(
          name = "AcTan",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(4.2547f, 15.7487f)
            curveTo(3.8547f, 15.7487f, 3.5464f, 15.637f, 3.3297f, 15.4137f)
            curveTo(3.1164f, 15.1904f, 3.0097f, 14.8687f, 3.0097f, 14.4487f)
            verticalLineTo(11.3487f)
            horizontalLineTo(2.3997f)
            curveTo(2.3464f, 11.3487f, 2.3014f, 11.3337f, 2.2647f, 11.3037f)
            curveTo(2.2281f, 11.2704f, 2.2097f, 11.2204f, 2.2097f, 11.1537f)
            verticalLineTo(10.7987f)
            lineTo(3.0397f, 10.6937f)
            lineTo(3.2447f, 9.1287f)
            curveTo(3.2547f, 9.0787f, 3.2764f, 9.0387f, 3.3097f, 9.0087f)
            curveTo(3.3464f, 8.9754f, 3.3931f, 8.9587f, 3.4497f, 8.9587f)
            horizontalLineTo(3.8997f)
            verticalLineTo(10.7037f)
            horizontalLineTo(5.3647f)
            verticalLineTo(11.3487f)
            horizontalLineTo(3.8997f)
            verticalLineTo(14.3887f)
            curveTo(3.8997f, 14.602f, 3.9514f, 14.7604f, 4.0547f, 14.8637f)
            curveTo(4.1581f, 14.967f, 4.2914f, 15.0187f, 4.4547f, 15.0187f)
            curveTo(4.5481f, 15.0187f, 4.6281f, 15.007f, 4.6947f, 14.9837f)
            curveTo(4.7647f, 14.957f, 4.8247f, 14.9287f, 4.8747f, 14.8987f)
            curveTo(4.9247f, 14.8687f, 4.9664f, 14.842f, 4.9997f, 14.8187f)
            curveTo(5.0364f, 14.792f, 5.0681f, 14.7787f, 5.0947f, 14.7787f)
            curveTo(5.1414f, 14.7787f, 5.1831f, 14.807f, 5.2197f, 14.8637f)
            lineTo(5.4797f, 15.2887f)
            curveTo(5.3264f, 15.432f, 5.1414f, 15.5454f, 4.9247f, 15.6287f)
            curveTo(4.7081f, 15.7087f, 4.4847f, 15.7487f, 4.2547f, 15.7487f)
            close()
            moveTo(8.8287f, 13.3887f)
            curveTo(8.4187f, 13.402f, 8.0687f, 13.4354f, 7.7787f, 13.4887f)
            curveTo(7.492f, 13.5387f, 7.257f, 13.6054f, 7.0737f, 13.6887f)
            curveTo(6.8937f, 13.772f, 6.762f, 13.8704f, 6.6787f, 13.9837f)
            curveTo(6.5987f, 14.097f, 6.5587f, 14.2237f, 6.5587f, 14.3637f)
            curveTo(6.5587f, 14.497f, 6.5804f, 14.612f, 6.6237f, 14.7087f)
            curveTo(6.667f, 14.8054f, 6.7254f, 14.8854f, 6.7987f, 14.9487f)
            curveTo(6.8754f, 15.0087f, 6.9637f, 15.0537f, 7.0637f, 15.0837f)
            curveTo(7.167f, 15.1104f, 7.277f, 15.1237f, 7.3937f, 15.1237f)
            curveTo(7.5504f, 15.1237f, 7.6937f, 15.1087f, 7.8237f, 15.0787f)
            curveTo(7.9537f, 15.0454f, 8.0754f, 14.9987f, 8.1887f, 14.9387f)
            curveTo(8.3054f, 14.8787f, 8.4154f, 14.807f, 8.5187f, 14.7237f)
            curveTo(8.6254f, 14.6404f, 8.7287f, 14.5454f, 8.8287f, 14.4387f)
            verticalLineTo(13.3887f)
            close()
            moveTo(5.9537f, 11.3187f)
            curveTo(6.2337f, 11.0487f, 6.5354f, 10.847f, 6.8587f, 10.7137f)
            curveTo(7.182f, 10.5804f, 7.5404f, 10.5137f, 7.9337f, 10.5137f)
            curveTo(8.217f, 10.5137f, 8.4687f, 10.5604f, 8.6887f, 10.6537f)
            curveTo(8.9087f, 10.747f, 9.0937f, 10.877f, 9.2437f, 11.0437f)
            curveTo(9.3937f, 11.2104f, 9.507f, 11.412f, 9.5837f, 11.6487f)
            curveTo(9.6604f, 11.8854f, 9.6987f, 12.1454f, 9.6987f, 12.4287f)
            verticalLineTo(15.6687f)
            horizontalLineTo(9.3037f)
            curveTo(9.217f, 15.6687f, 9.1504f, 15.6554f, 9.1037f, 15.6287f)
            curveTo(9.057f, 15.5987f, 9.0204f, 15.542f, 8.9937f, 15.4587f)
            lineTo(8.8937f, 14.9787f)
            curveTo(8.7604f, 15.102f, 8.6304f, 15.212f, 8.5037f, 15.3087f)
            curveTo(8.377f, 15.402f, 8.2437f, 15.482f, 8.1037f, 15.5487f)
            curveTo(7.9637f, 15.612f, 7.8137f, 15.6604f, 7.6537f, 15.6937f)
            curveTo(7.497f, 15.7304f, 7.322f, 15.7487f, 7.1287f, 15.7487f)
            curveTo(6.932f, 15.7487f, 6.747f, 15.722f, 6.5737f, 15.6687f)
            curveTo(6.4004f, 15.612f, 6.2487f, 15.5287f, 6.1187f, 15.4187f)
            curveTo(5.992f, 15.3087f, 5.8904f, 15.1704f, 5.8137f, 15.0037f)
            curveTo(5.7404f, 14.8337f, 5.7037f, 14.6337f, 5.7037f, 14.4037f)
            curveTo(5.7037f, 14.2037f, 5.7587f, 14.012f, 5.8687f, 13.8287f)
            curveTo(5.9787f, 13.642f, 6.157f, 13.477f, 6.4037f, 13.3337f)
            curveTo(6.6504f, 13.1904f, 6.972f, 13.0737f, 7.3687f, 12.9837f)
            curveTo(7.7654f, 12.8904f, 8.252f, 12.837f, 8.8287f, 12.8237f)
            verticalLineTo(12.4287f)
            curveTo(8.8287f, 12.0354f, 8.7437f, 11.7387f, 8.5737f, 11.5387f)
            curveTo(8.4037f, 11.3354f, 8.1554f, 11.2337f, 7.8287f, 11.2337f)
            curveTo(7.6087f, 11.2337f, 7.4237f, 11.262f, 7.2737f, 11.3187f)
            curveTo(7.127f, 11.372f, 6.9987f, 11.4337f, 6.8887f, 11.5037f)
            curveTo(6.782f, 11.5704f, 6.6887f, 11.632f, 6.6087f, 11.6887f)
            curveTo(6.532f, 11.742f, 6.4554f, 11.7687f, 6.3787f, 11.7687f)
            curveTo(6.3187f, 11.7687f, 6.267f, 11.7537f, 6.2237f, 11.7237f)
            curveTo(6.1804f, 11.6904f, 6.1437f, 11.6504f, 6.1137f, 11.6037f)
            lineTo(5.9537f, 11.3187f)
            close()
            moveTo(11.6944f, 11.3387f)
            curveTo(11.8044f, 11.2154f, 11.9211f, 11.1037f, 12.0444f, 11.0037f)
            curveTo(12.1677f, 10.9037f, 12.2977f, 10.8187f, 12.4344f, 10.7487f)
            curveTo(12.5744f, 10.6754f, 12.7211f, 10.6204f, 12.8744f, 10.5837f)
            curveTo(13.0311f, 10.5437f, 13.1994f, 10.5237f, 13.3794f, 10.5237f)
            curveTo(13.6561f, 10.5237f, 13.8994f, 10.5704f, 14.1094f, 10.6637f)
            curveTo(14.3227f, 10.7537f, 14.4994f, 10.8837f, 14.6394f, 11.0537f)
            curveTo(14.7827f, 11.2204f, 14.8911f, 11.422f, 14.9644f, 11.6587f)
            curveTo(15.0377f, 11.8954f, 15.0744f, 12.157f, 15.0744f, 12.4437f)
            verticalLineTo(15.6687f)
            horizontalLineTo(14.1794f)
            verticalLineTo(12.4437f)
            curveTo(14.1794f, 12.0604f, 14.0911f, 11.7637f, 13.9144f, 11.5537f)
            curveTo(13.7411f, 11.3404f, 13.4761f, 11.2337f, 13.1194f, 11.2337f)
            curveTo(12.8561f, 11.2337f, 12.6094f, 11.297f, 12.3794f, 11.4237f)
            curveTo(12.1527f, 11.5504f, 11.9427f, 11.722f, 11.7494f, 11.9387f)
            verticalLineTo(15.6687f)
            horizontalLineTo(10.8544f)
            verticalLineTo(10.6037f)
            horizontalLineTo(11.3894f)
            curveTo(11.5161f, 10.6037f, 11.5944f, 10.6654f, 11.6244f, 10.7887f)
            lineTo(11.6944f, 11.3387f)
            close()
            moveTo(16.0756f, 9.1837f)
            horizontalLineTo(18.3156f)
            verticalLineTo(9.6637f)
            horizontalLineTo(16.0756f)
            verticalLineTo(9.1837f)
            close()
            moveTo(21.4904f, 10.7437f)
            verticalLineTo(11.1687f)
            horizontalLineTo(19.4554f)
            verticalLineTo(10.7437f)
            horizontalLineTo(20.1904f)
            verticalLineTo(8.5437f)
            lineTo(20.2154f, 8.3237f)
            lineTo(19.6754f, 8.7687f)
            curveTo(19.6454f, 8.792f, 19.6154f, 8.807f, 19.5854f, 8.8137f)
            curveTo(19.5588f, 8.817f, 19.5321f, 8.817f, 19.5054f, 8.8137f)
            curveTo(19.4788f, 8.807f, 19.4538f, 8.797f, 19.4304f, 8.7837f)
            curveTo(19.4104f, 8.7704f, 19.3954f, 8.757f, 19.3854f, 8.7437f)
            lineTo(19.1904f, 8.4637f)
            lineTo(20.3004f, 7.5137f)
            horizontalLineTo(20.8404f)
            verticalLineTo(10.7437f)
            horizontalLineTo(21.4904f)
            close()
          }
        }
        .build()
    return _arTan!!
  }

private var _arTan: ImageVector? = null
