/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.ArSin: ImageVector
  get() {
    if (_arSin != null) {
      return _arSin!!
    }
    _arSin =
      Builder(
          name = "ArSin",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(6.5628f, 11.4387f)
            curveTo(6.5228f, 11.512f, 6.4612f, 11.5487f, 6.3778f, 11.5487f)
            curveTo(6.3278f, 11.5487f, 6.2712f, 11.5304f, 6.2078f, 11.4937f)
            curveTo(6.1445f, 11.457f, 6.0662f, 11.417f, 5.9728f, 11.3737f)
            curveTo(5.8828f, 11.327f, 5.7745f, 11.2854f, 5.6478f, 11.2487f)
            curveTo(5.5212f, 11.2087f, 5.3712f, 11.1887f, 5.1978f, 11.1887f)
            curveTo(5.0478f, 11.1887f, 4.9128f, 11.2087f, 4.7928f, 11.2487f)
            curveTo(4.6728f, 11.2854f, 4.5695f, 11.337f, 4.4828f, 11.4037f)
            curveTo(4.3995f, 11.4704f, 4.3345f, 11.5487f, 4.2878f, 11.6387f)
            curveTo(4.2445f, 11.7254f, 4.2228f, 11.8204f, 4.2228f, 11.9237f)
            curveTo(4.2228f, 12.0537f, 4.2595f, 12.162f, 4.3328f, 12.2487f)
            curveTo(4.4095f, 12.3354f, 4.5095f, 12.4104f, 4.6328f, 12.4737f)
            curveTo(4.7561f, 12.537f, 4.8962f, 12.5937f, 5.0528f, 12.6437f)
            curveTo(5.2095f, 12.6904f, 5.3695f, 12.742f, 5.5328f, 12.7987f)
            curveTo(5.6995f, 12.852f, 5.8611f, 12.912f, 6.0178f, 12.9787f)
            curveTo(6.1745f, 13.0454f, 6.3145f, 13.1287f, 6.4378f, 13.2287f)
            curveTo(6.5612f, 13.3287f, 6.6595f, 13.452f, 6.7328f, 13.5987f)
            curveTo(6.8095f, 13.742f, 6.8478f, 13.9154f, 6.8478f, 14.1187f)
            curveTo(6.8478f, 14.352f, 6.8061f, 14.5687f, 6.7228f, 14.7687f)
            curveTo(6.6395f, 14.9654f, 6.5161f, 15.137f, 6.3528f, 15.2837f)
            curveTo(6.1895f, 15.427f, 5.9895f, 15.5404f, 5.7528f, 15.6237f)
            curveTo(5.5161f, 15.707f, 5.2428f, 15.7487f, 4.9328f, 15.7487f)
            curveTo(4.5795f, 15.7487f, 4.2595f, 15.692f, 3.9728f, 15.5787f)
            curveTo(3.6862f, 15.462f, 3.4428f, 15.3137f, 3.2428f, 15.1337f)
            lineTo(3.4528f, 14.7937f)
            curveTo(3.4795f, 14.7504f, 3.5111f, 14.717f, 3.5478f, 14.6937f)
            curveTo(3.5845f, 14.6704f, 3.6312f, 14.6587f, 3.6878f, 14.6587f)
            curveTo(3.7478f, 14.6587f, 3.8112f, 14.682f, 3.8778f, 14.7287f)
            curveTo(3.9445f, 14.7754f, 4.0245f, 14.827f, 4.1178f, 14.8837f)
            curveTo(4.2145f, 14.9404f, 4.3312f, 14.992f, 4.4678f, 15.0387f)
            curveTo(4.6045f, 15.0854f, 4.7745f, 15.1087f, 4.9778f, 15.1087f)
            curveTo(5.1512f, 15.1087f, 5.3028f, 15.087f, 5.4328f, 15.0437f)
            curveTo(5.5628f, 14.997f, 5.6712f, 14.9354f, 5.7578f, 14.8587f)
            curveTo(5.8445f, 14.782f, 5.9078f, 14.6937f, 5.9478f, 14.5937f)
            curveTo(5.9911f, 14.4937f, 6.0128f, 14.387f, 6.0128f, 14.2737f)
            curveTo(6.0128f, 14.1337f, 5.9745f, 14.0187f, 5.8978f, 13.9287f)
            curveTo(5.8245f, 13.8354f, 5.7262f, 13.757f, 5.6028f, 13.6937f)
            curveTo(5.4795f, 13.627f, 5.3378f, 13.5704f, 5.1778f, 13.5237f)
            curveTo(5.0212f, 13.4737f, 4.8595f, 13.422f, 4.6928f, 13.3687f)
            curveTo(4.5295f, 13.3154f, 4.3678f, 13.2554f, 4.2078f, 13.1887f)
            curveTo(4.0511f, 13.1187f, 3.9111f, 13.032f, 3.7878f, 12.9287f)
            curveTo(3.6645f, 12.8254f, 3.5645f, 12.6987f, 3.4878f, 12.5487f)
            curveTo(3.4145f, 12.3954f, 3.3778f, 12.2104f, 3.3778f, 11.9937f)
            curveTo(3.3778f, 11.8004f, 3.4178f, 11.6154f, 3.4978f, 11.4387f)
            curveTo(3.5778f, 11.2587f, 3.6945f, 11.102f, 3.8478f, 10.9687f)
            curveTo(4.0012f, 10.832f, 4.1895f, 10.7237f, 4.4128f, 10.6437f)
            curveTo(4.6361f, 10.5637f, 4.8911f, 10.5237f, 5.1778f, 10.5237f)
            curveTo(5.5111f, 10.5237f, 5.8095f, 10.577f, 6.0728f, 10.6837f)
            curveTo(6.3395f, 10.787f, 6.5695f, 10.9304f, 6.7628f, 11.1137f)
            lineTo(6.5628f, 11.4387f)
            close()
            moveTo(8.679f, 10.6037f)
            verticalLineTo(15.6687f)
            horizontalLineTo(7.789f)
            verticalLineTo(10.6037f)
            horizontalLineTo(8.679f)
            close()
            moveTo(8.869f, 9.0137f)
            curveTo(8.869f, 9.1004f, 8.8506f, 9.182f, 8.814f, 9.2587f)
            curveTo(8.7807f, 9.332f, 8.734f, 9.3987f, 8.674f, 9.4587f)
            curveTo(8.6173f, 9.5154f, 8.549f, 9.5604f, 8.469f, 9.5937f)
            curveTo(8.3923f, 9.627f, 8.3106f, 9.6437f, 8.224f, 9.6437f)
            curveTo(8.1373f, 9.6437f, 8.0556f, 9.627f, 7.979f, 9.5937f)
            curveTo(7.9057f, 9.5604f, 7.8407f, 9.5154f, 7.784f, 9.4587f)
            curveTo(7.7273f, 9.3987f, 7.6823f, 9.332f, 7.649f, 9.2587f)
            curveTo(7.6157f, 9.182f, 7.599f, 9.1004f, 7.599f, 9.0137f)
            curveTo(7.599f, 8.927f, 7.6157f, 8.8454f, 7.649f, 8.7687f)
            curveTo(7.6823f, 8.6887f, 7.7273f, 8.6204f, 7.784f, 8.5637f)
            curveTo(7.8407f, 8.5037f, 7.9057f, 8.457f, 7.979f, 8.4237f)
            curveTo(8.0556f, 8.3904f, 8.1373f, 8.3737f, 8.224f, 8.3737f)
            curveTo(8.3106f, 8.3737f, 8.3923f, 8.3904f, 8.469f, 8.4237f)
            curveTo(8.549f, 8.457f, 8.6173f, 8.5037f, 8.674f, 8.5637f)
            curveTo(8.734f, 8.6204f, 8.7807f, 8.6887f, 8.814f, 8.7687f)
            curveTo(8.8506f, 8.8454f, 8.869f, 8.927f, 8.869f, 9.0137f)
            close()
            moveTo(10.7813f, 11.3387f)
            curveTo(10.8913f, 11.2154f, 11.008f, 11.1037f, 11.1313f, 11.0037f)
            curveTo(11.2547f, 10.9037f, 11.3847f, 10.8187f, 11.5213f, 10.7487f)
            curveTo(11.6613f, 10.6754f, 11.808f, 10.6204f, 11.9613f, 10.5837f)
            curveTo(12.118f, 10.5437f, 12.2863f, 10.5237f, 12.4663f, 10.5237f)
            curveTo(12.743f, 10.5237f, 12.9863f, 10.5704f, 13.1963f, 10.6637f)
            curveTo(13.4097f, 10.7537f, 13.5863f, 10.8837f, 13.7263f, 11.0537f)
            curveTo(13.8697f, 11.2204f, 13.978f, 11.422f, 14.0513f, 11.6587f)
            curveTo(14.1247f, 11.8954f, 14.1613f, 12.157f, 14.1613f, 12.4437f)
            verticalLineTo(15.6687f)
            horizontalLineTo(13.2663f)
            verticalLineTo(12.4437f)
            curveTo(13.2663f, 12.0604f, 13.178f, 11.7637f, 13.0013f, 11.5537f)
            curveTo(12.828f, 11.3404f, 12.563f, 11.2337f, 12.2063f, 11.2337f)
            curveTo(11.943f, 11.2337f, 11.6963f, 11.297f, 11.4663f, 11.4237f)
            curveTo(11.2397f, 11.5504f, 11.0297f, 11.722f, 10.8363f, 11.9387f)
            verticalLineTo(15.6687f)
            horizontalLineTo(9.9413f)
            verticalLineTo(10.6037f)
            horizontalLineTo(10.4763f)
            curveTo(10.603f, 10.6037f, 10.6813f, 10.6654f, 10.7113f, 10.7887f)
            lineTo(10.7813f, 11.3387f)
            close()
            moveTo(15.1625f, 9.1837f)
            horizontalLineTo(17.4025f)
            verticalLineTo(9.6637f)
            horizontalLineTo(15.1625f)
            verticalLineTo(9.1837f)
            close()
            moveTo(20.5773f, 10.7437f)
            verticalLineTo(11.1687f)
            horizontalLineTo(18.5423f)
            verticalLineTo(10.7437f)
            horizontalLineTo(19.2773f)
            verticalLineTo(8.5437f)
            lineTo(19.3023f, 8.3237f)
            lineTo(18.7623f, 8.7687f)
            curveTo(18.7323f, 8.792f, 18.7023f, 8.807f, 18.6723f, 8.8137f)
            curveTo(18.6457f, 8.817f, 18.619f, 8.817f, 18.5923f, 8.8137f)
            curveTo(18.5657f, 8.807f, 18.5407f, 8.797f, 18.5173f, 8.7837f)
            curveTo(18.4973f, 8.7704f, 18.4823f, 8.757f, 18.4723f, 8.7437f)
            lineTo(18.2773f, 8.4637f)
            lineTo(19.3873f, 7.5137f)
            horizontalLineTo(19.9273f)
            verticalLineTo(10.7437f)
            horizontalLineTo(20.5773f)
            close()
          }
        }
        .build()
    return _arSin!!
  }

private var _arSin: ImageVector? = null
