package com.sadellie.unitto.core.designsystem.icons.symbols

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Symbols.DragHandle: ImageVector
  get() {
    if (_DragHandle != null) {
      return _DragHandle!!
    }
    _DragHandle = ImageVector.Builder(
      name = "DragHandle",
      defaultWidth = 24.dp,
      defaultHeight = 24.dp,
      viewportWidth = 960f,
      viewportHeight = 960f
    ).apply {
      path(fill = SolidColor(Color(0xFFE8EAED))) {
        moveTo(200f, 600f)
        quadToRelative(-17f, 0f, -28.5f, -11.5f)
        reflectiveQuadTo(160f, 560f)
        quadToRelative(0f, -17f, 11.5f, -28.5f)
        reflectiveQuadTo(200f, 520f)
        horizontalLineToRelative(560f)
        quadToRelative(17f, 0f, 28.5f, 11.5f)
        reflectiveQuadTo(800f, 560f)
        quadToRelative(0f, 17f, -11.5f, 28.5f)
        reflectiveQuadTo(760f, 600f)
        lineTo(200f, 600f)
        close()
        moveTo(200f, 440f)
        quadToRelative(-17f, 0f, -28.5f, -11.5f)
        reflectiveQuadTo(160f, 400f)
        quadToRelative(0f, -17f, 11.5f, -28.5f)
        reflectiveQuadTo(200f, 360f)
        horizontalLineToRelative(560f)
        quadToRelative(17f, 0f, 28.5f, 11.5f)
        reflectiveQuadTo(800f, 400f)
        quadToRelative(0f, 17f, -11.5f, 28.5f)
        reflectiveQuadTo(760f, 440f)
        lineTo(200f, 440f)
        close()
      }
    }.build()

    return _DragHandle!!
  }

@Suppress("ObjectPropertyName")
private var _DragHandle: ImageVector? = null
