/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.Tan: ImageVector
  get() {
    if (_tan != null) {
      return _tan!!
    }
    _tan =
      Builder(
          name = "Tan",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(7.3946f, 15.7487f)
            curveTo(6.9946f, 15.7487f, 6.6862f, 15.637f, 6.4696f, 15.4137f)
            curveTo(6.2562f, 15.1904f, 6.1496f, 14.8687f, 6.1496f, 14.4487f)
            verticalLineTo(11.3487f)
            horizontalLineTo(5.5396f)
            curveTo(5.4862f, 11.3487f, 5.4412f, 11.3337f, 5.4046f, 11.3037f)
            curveTo(5.3679f, 11.2704f, 5.3496f, 11.2204f, 5.3496f, 11.1537f)
            verticalLineTo(10.7987f)
            lineTo(6.1796f, 10.6937f)
            lineTo(6.3846f, 9.1287f)
            curveTo(6.3946f, 9.0787f, 6.4162f, 9.0387f, 6.4496f, 9.0087f)
            curveTo(6.4862f, 8.9754f, 6.5329f, 8.9587f, 6.5896f, 8.9587f)
            horizontalLineTo(7.0396f)
            verticalLineTo(10.7037f)
            horizontalLineTo(8.5046f)
            verticalLineTo(11.3487f)
            horizontalLineTo(7.0396f)
            verticalLineTo(14.3887f)
            curveTo(7.0396f, 14.602f, 7.0912f, 14.7604f, 7.1946f, 14.8637f)
            curveTo(7.2979f, 14.967f, 7.4312f, 15.0187f, 7.5946f, 15.0187f)
            curveTo(7.6879f, 15.0187f, 7.7679f, 15.007f, 7.8346f, 14.9837f)
            curveTo(7.9046f, 14.957f, 7.9646f, 14.9287f, 8.0146f, 14.8987f)
            curveTo(8.0646f, 14.8687f, 8.1062f, 14.842f, 8.1396f, 14.8187f)
            curveTo(8.1762f, 14.792f, 8.2079f, 14.7787f, 8.2346f, 14.7787f)
            curveTo(8.2812f, 14.7787f, 8.3229f, 14.807f, 8.3596f, 14.8637f)
            lineTo(8.6196f, 15.2887f)
            curveTo(8.4662f, 15.432f, 8.2812f, 15.5454f, 8.0646f, 15.6287f)
            curveTo(7.8479f, 15.7087f, 7.6246f, 15.7487f, 7.3946f, 15.7487f)
            close()
            moveTo(11.9686f, 13.3887f)
            curveTo(11.5586f, 13.402f, 11.2086f, 13.4354f, 10.9186f, 13.4887f)
            curveTo(10.6319f, 13.5387f, 10.3969f, 13.6054f, 10.2136f, 13.6887f)
            curveTo(10.0336f, 13.772f, 9.9019f, 13.8704f, 9.8186f, 13.9837f)
            curveTo(9.7386f, 14.097f, 9.6986f, 14.2237f, 9.6986f, 14.3637f)
            curveTo(9.6986f, 14.497f, 9.7202f, 14.612f, 9.7635f, 14.7087f)
            curveTo(9.8069f, 14.8054f, 9.8652f, 14.8854f, 9.9385f, 14.9487f)
            curveTo(10.0152f, 15.0087f, 10.1036f, 15.0537f, 10.2036f, 15.0837f)
            curveTo(10.3069f, 15.1104f, 10.4169f, 15.1237f, 10.5336f, 15.1237f)
            curveTo(10.6902f, 15.1237f, 10.8336f, 15.1087f, 10.9636f, 15.0787f)
            curveTo(11.0936f, 15.0454f, 11.2152f, 14.9987f, 11.3286f, 14.9387f)
            curveTo(11.4452f, 14.8787f, 11.5552f, 14.807f, 11.6586f, 14.7237f)
            curveTo(11.7652f, 14.6404f, 11.8686f, 14.5454f, 11.9686f, 14.4387f)
            verticalLineTo(13.3887f)
            close()
            moveTo(9.0935f, 11.3187f)
            curveTo(9.3736f, 11.0487f, 9.6752f, 10.847f, 9.9986f, 10.7137f)
            curveTo(10.3219f, 10.5804f, 10.6802f, 10.5137f, 11.0736f, 10.5137f)
            curveTo(11.3569f, 10.5137f, 11.6086f, 10.5604f, 11.8286f, 10.6537f)
            curveTo(12.0486f, 10.747f, 12.2336f, 10.877f, 12.3836f, 11.0437f)
            curveTo(12.5336f, 11.2104f, 12.6469f, 11.412f, 12.7236f, 11.6487f)
            curveTo(12.8002f, 11.8854f, 12.8386f, 12.1454f, 12.8386f, 12.4287f)
            verticalLineTo(15.6687f)
            horizontalLineTo(12.4436f)
            curveTo(12.3569f, 15.6687f, 12.2902f, 15.6554f, 12.2436f, 15.6287f)
            curveTo(12.1969f, 15.5987f, 12.1602f, 15.542f, 12.1336f, 15.4587f)
            lineTo(12.0336f, 14.9787f)
            curveTo(11.9002f, 15.102f, 11.7702f, 15.212f, 11.6436f, 15.3087f)
            curveTo(11.5169f, 15.402f, 11.3836f, 15.482f, 11.2436f, 15.5487f)
            curveTo(11.1036f, 15.612f, 10.9536f, 15.6604f, 10.7936f, 15.6937f)
            curveTo(10.6369f, 15.7304f, 10.4619f, 15.7487f, 10.2686f, 15.7487f)
            curveTo(10.0719f, 15.7487f, 9.8869f, 15.722f, 9.7135f, 15.6687f)
            curveTo(9.5402f, 15.612f, 9.3885f, 15.5287f, 9.2585f, 15.4187f)
            curveTo(9.1319f, 15.3087f, 9.0302f, 15.1704f, 8.9536f, 15.0037f)
            curveTo(8.8802f, 14.8337f, 8.8435f, 14.6337f, 8.8435f, 14.4037f)
            curveTo(8.8435f, 14.2037f, 8.8986f, 14.012f, 9.0085f, 13.8287f)
            curveTo(9.1186f, 13.642f, 9.2969f, 13.477f, 9.5435f, 13.3337f)
            curveTo(9.7902f, 13.1904f, 10.1119f, 13.0737f, 10.5086f, 12.9837f)
            curveTo(10.9052f, 12.8904f, 11.3919f, 12.837f, 11.9686f, 12.8237f)
            verticalLineTo(12.4287f)
            curveTo(11.9686f, 12.0354f, 11.8836f, 11.7387f, 11.7136f, 11.5387f)
            curveTo(11.5436f, 11.3354f, 11.2952f, 11.2337f, 10.9686f, 11.2337f)
            curveTo(10.7486f, 11.2337f, 10.5636f, 11.262f, 10.4136f, 11.3187f)
            curveTo(10.2669f, 11.372f, 10.1386f, 11.4337f, 10.0286f, 11.5037f)
            curveTo(9.9219f, 11.5704f, 9.8286f, 11.632f, 9.7486f, 11.6887f)
            curveTo(9.6719f, 11.742f, 9.5952f, 11.7687f, 9.5185f, 11.7687f)
            curveTo(9.4586f, 11.7687f, 9.4069f, 11.7537f, 9.3636f, 11.7237f)
            curveTo(9.3202f, 11.6904f, 9.2836f, 11.6504f, 9.2535f, 11.6037f)
            lineTo(9.0935f, 11.3187f)
            close()
            moveTo(14.8343f, 11.3387f)
            curveTo(14.9443f, 11.2154f, 15.0609f, 11.1037f, 15.1843f, 11.0037f)
            curveTo(15.3076f, 10.9037f, 15.4376f, 10.8187f, 15.5743f, 10.7487f)
            curveTo(15.7143f, 10.6754f, 15.8609f, 10.6204f, 16.0143f, 10.5837f)
            curveTo(16.1709f, 10.5437f, 16.3393f, 10.5237f, 16.5193f, 10.5237f)
            curveTo(16.7959f, 10.5237f, 17.0393f, 10.5704f, 17.2493f, 10.6637f)
            curveTo(17.4626f, 10.7537f, 17.6393f, 10.8837f, 17.7793f, 11.0537f)
            curveTo(17.9226f, 11.2204f, 18.0309f, 11.422f, 18.1043f, 11.6587f)
            curveTo(18.1776f, 11.8954f, 18.2143f, 12.157f, 18.2143f, 12.4437f)
            verticalLineTo(15.6687f)
            horizontalLineTo(17.3193f)
            verticalLineTo(12.4437f)
            curveTo(17.3193f, 12.0604f, 17.2309f, 11.7637f, 17.0543f, 11.5537f)
            curveTo(16.8809f, 11.3404f, 16.6159f, 11.2337f, 16.2593f, 11.2337f)
            curveTo(15.9959f, 11.2337f, 15.7493f, 11.297f, 15.5193f, 11.4237f)
            curveTo(15.2926f, 11.5504f, 15.0826f, 11.722f, 14.8893f, 11.9387f)
            verticalLineTo(15.6687f)
            horizontalLineTo(13.9943f)
            verticalLineTo(10.6037f)
            horizontalLineTo(14.5293f)
            curveTo(14.6559f, 10.6037f, 14.7343f, 10.6654f, 14.7643f, 10.7887f)
            lineTo(14.8343f, 11.3387f)
            close()
          }
        }
        .build()
    return _tan!!
  }

private var _tan: ImageVector? = null
