/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.Fraction: ImageVector
  get() {
    if (_Fraction != null) {
      return _Fraction!!
    }
    _Fraction = ImageVector.Builder(
      name = "Fraction",
      defaultWidth = 24.dp,
      defaultHeight = 24.dp,
      viewportWidth = 24f,
      viewportHeight = 24f
    ).apply {
      path(fill = SolidColor(Color(0xFF000000))) {
        moveTo(14.745f, 14.923f)
        curveTo(14.816f, 14.438f, 14.951f, 14.013f, 15.151f, 13.649f)
        curveTo(15.352f, 13.281f, 15.602f, 12.975f, 15.901f, 12.732f)
        curveTo(16.204f, 12.485f, 16.549f, 12.3f, 16.937f, 12.179f)
        curveTo(17.329f, 12.053f, 17.749f, 11.99f, 18.197f, 11.99f)
        curveTo(18.663f, 11.99f, 19.083f, 12.058f, 19.456f, 12.193f)
        curveTo(19.834f, 12.324f, 20.156f, 12.508f, 20.423f, 12.746f)
        curveTo(20.688f, 12.979f, 20.892f, 13.255f, 21.031f, 13.572f)
        curveTo(21.176f, 13.889f, 21.249f, 14.233f, 21.249f, 14.601f)
        curveTo(21.249f, 14.923f, 21.211f, 15.208f, 21.136f, 15.455f)
        curveTo(21.066f, 15.698f, 20.964f, 15.91f, 20.829f, 16.092f)
        curveTo(20.693f, 16.274f, 20.525f, 16.428f, 20.324f, 16.554f)
        curveTo(20.124f, 16.68f, 19.897f, 16.785f, 19.646f, 16.869f)
        curveTo(20.252f, 17.06f, 20.705f, 17.352f, 21.003f, 17.744f)
        curveTo(21.302f, 18.136f, 21.451f, 18.628f, 21.451f, 19.221f)
        curveTo(21.451f, 19.725f, 21.358f, 20.171f, 21.171f, 20.558f)
        curveTo(20.985f, 20.945f, 20.733f, 21.272f, 20.416f, 21.538f)
        curveTo(20.098f, 21.799f, 19.729f, 21.998f, 19.309f, 22.133f)
        curveTo(18.894f, 22.268f, 18.453f, 22.336f, 17.986f, 22.336f)
        curveTo(17.478f, 22.336f, 17.035f, 22.278f, 16.656f, 22.161f)
        curveTo(16.278f, 22.045f, 15.95f, 21.872f, 15.67f, 21.643f)
        curveTo(15.389f, 21.414f, 15.151f, 21.135f, 14.955f, 20.803f)
        curveTo(14.759f, 20.472f, 14.592f, 20.089f, 14.451f, 19.655f)
        lineTo(15.215f, 19.34f)
        curveTo(15.415f, 19.256f, 15.602f, 19.235f, 15.774f, 19.277f)
        curveTo(15.952f, 19.315f, 16.08f, 19.408f, 16.16f, 19.557f)
        curveTo(16.243f, 19.721f, 16.334f, 19.882f, 16.433f, 20.04f)
        curveTo(16.535f, 20.199f, 16.656f, 20.341f, 16.796f, 20.467f)
        curveTo(16.937f, 20.588f, 17.1f, 20.689f, 17.287f, 20.768f)
        curveTo(17.478f, 20.843f, 17.704f, 20.88f, 17.965f, 20.88f)
        curveTo(18.26f, 20.88f, 18.516f, 20.833f, 18.736f, 20.74f)
        curveTo(18.955f, 20.642f, 19.137f, 20.516f, 19.281f, 20.362f)
        curveTo(19.431f, 20.208f, 19.541f, 20.038f, 19.611f, 19.851f)
        curveTo(19.685f, 19.66f, 19.722f, 19.469f, 19.722f, 19.277f)
        curveTo(19.722f, 19.035f, 19.697f, 18.815f, 19.646f, 18.619f)
        curveTo(19.594f, 18.419f, 19.487f, 18.248f, 19.323f, 18.108f)
        curveTo(19.16f, 17.968f, 18.924f, 17.858f, 18.617f, 17.779f)
        curveTo(18.313f, 17.7f, 17.905f, 17.66f, 17.392f, 17.66f)
        verticalLineTo(16.428f)
        curveTo(17.816f, 16.424f, 18.169f, 16.384f, 18.448f, 16.309f)
        curveTo(18.729f, 16.235f, 18.95f, 16.132f, 19.114f, 16.001f)
        curveTo(19.281f, 15.866f, 19.398f, 15.705f, 19.463f, 15.518f)
        curveTo(19.529f, 15.332f, 19.562f, 15.126f, 19.562f, 14.902f)
        curveTo(19.562f, 14.426f, 19.428f, 14.064f, 19.163f, 13.817f)
        curveTo(18.896f, 13.57f, 18.542f, 13.446f, 18.098f, 13.446f)
        curveTo(17.893f, 13.446f, 17.704f, 13.476f, 17.531f, 13.537f)
        curveTo(17.359f, 13.593f, 17.202f, 13.675f, 17.063f, 13.782f)
        curveTo(16.927f, 13.885f, 16.813f, 14.006f, 16.719f, 14.146f)
        curveTo(16.626f, 14.286f, 16.556f, 14.44f, 16.51f, 14.608f)
        curveTo(16.43f, 14.823f, 16.325f, 14.965f, 16.194f, 15.035f)
        curveTo(16.069f, 15.105f, 15.889f, 15.122f, 15.656f, 15.084f)
        lineTo(14.745f, 14.923f)
        close()
      }
      path(fill = SolidColor(Color(0xFF000000))) {
        moveTo(9.134f, 10.481f)
        verticalLineTo(11.776f)
        horizontalLineTo(3.534f)
        verticalLineTo(10.481f)
        horizontalLineTo(5.585f)
        verticalLineTo(4.58f)
        curveTo(5.585f, 4.347f, 5.592f, 4.106f, 5.606f, 3.859f)
        lineTo(4.15f, 5.077f)
        curveTo(4.066f, 5.142f, 3.982f, 5.184f, 3.898f, 5.203f)
        curveTo(3.819f, 5.217f, 3.742f, 5.217f, 3.667f, 5.203f)
        curveTo(3.597f, 5.189f, 3.534f, 5.166f, 3.478f, 5.133f)
        curveTo(3.422f, 5.096f, 3.38f, 5.056f, 3.352f, 5.014f)
        lineTo(2.806f, 4.265f)
        lineTo(5.893f, 1.64f)
        horizontalLineTo(7.314f)
        verticalLineTo(10.481f)
        horizontalLineTo(9.134f)
        close()
      }
      path(fill = SolidColor(Color(0xFF000000))) {
        moveTo(5.429f, 17.657f)
        lineTo(18.157f, 4.929f)
        lineTo(19.571f, 6.343f)
        lineTo(6.843f, 19.071f)
        lineTo(5.429f, 17.657f)
        close()
      }
    }.build()

    return _Fraction!!
  }

@Suppress("ObjectPropertyName")
private var _Fraction: ImageVector? = null
