/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.ClearBold: ImageVector
  get() {
    if (_ClearBold != null) {
      return _ClearBold!!
    }
    _ClearBold = ImageVector.Builder(
      name = "IconName",
      defaultWidth = 24.dp,
      defaultHeight = 24.dp,
      viewportWidth = 24f,
      viewportHeight = 24f
    ).apply {
      path(fill = SolidColor(Color(0xFF000000))) {
        moveTo(9.216f, 13.349f)
        lineTo(7.632f, 9.141f)
        curveTo(7.504f, 8.815f, 7.373f, 8.402f, 7.24f, 7.901f)
        curveTo(7.181f, 8.151f, 7.117f, 8.383f, 7.048f, 8.597f)
        curveTo(6.978f, 8.805f, 6.914f, 8.989f, 6.856f, 9.149f)
        lineTo(5.272f, 13.349f)
        horizontalLineTo(9.216f)
        close()
        moveTo(12.76f, 17.669f)
        horizontalLineTo(11.312f)
        curveTo(11.146f, 17.669f, 11.013f, 17.629f, 10.912f, 17.549f)
        curveTo(10.81f, 17.463f, 10.733f, 17.359f, 10.68f, 17.237f)
        lineTo(9.72f, 14.693f)
        horizontalLineTo(4.76f)
        lineTo(3.8f, 17.237f)
        curveTo(3.757f, 17.343f, 3.682f, 17.442f, 3.576f, 17.533f)
        curveTo(3.469f, 17.623f, 3.336f, 17.669f, 3.176f, 17.669f)
        horizontalLineTo(1.728f)
        lineTo(6.296f, 6.149f)
        horizontalLineTo(8.192f)
        lineTo(12.76f, 17.669f)
        close()
        moveTo(20.991f, 15.101f)
        curveTo(21.093f, 15.101f, 21.181f, 15.141f, 21.255f, 15.221f)
        lineTo(21.999f, 16.029f)
        curveTo(21.53f, 16.594f, 20.954f, 17.031f, 20.271f, 17.341f)
        curveTo(19.589f, 17.645f, 18.773f, 17.797f, 17.823f, 17.797f)
        curveTo(16.981f, 17.797f, 16.218f, 17.653f, 15.535f, 17.365f)
        curveTo(14.858f, 17.071f, 14.279f, 16.666f, 13.799f, 16.149f)
        curveTo(13.319f, 15.626f, 12.949f, 15.005f, 12.687f, 14.285f)
        curveTo(12.431f, 13.565f, 12.303f, 12.773f, 12.303f, 11.909f)
        curveTo(12.303f, 11.045f, 12.439f, 10.253f, 12.711f, 9.533f)
        curveTo(12.989f, 8.807f, 13.375f, 8.186f, 13.871f, 7.669f)
        curveTo(14.373f, 7.146f, 14.97f, 6.741f, 15.663f, 6.453f)
        curveTo(16.362f, 6.165f, 17.13f, 6.021f, 17.967f, 6.021f)
        curveTo(18.799f, 6.021f, 19.533f, 6.157f, 20.167f, 6.429f)
        curveTo(20.807f, 6.695f, 21.362f, 7.053f, 21.831f, 7.501f)
        lineTo(21.215f, 8.373f)
        curveTo(21.173f, 8.431f, 21.122f, 8.482f, 21.063f, 8.525f)
        curveTo(21.005f, 8.567f, 20.925f, 8.589f, 20.823f, 8.589f)
        curveTo(20.717f, 8.589f, 20.594f, 8.541f, 20.455f, 8.445f)
        curveTo(20.322f, 8.343f, 20.149f, 8.234f, 19.935f, 8.117f)
        curveTo(19.727f, 7.994f, 19.463f, 7.885f, 19.143f, 7.789f)
        curveTo(18.829f, 7.687f, 18.434f, 7.637f, 17.959f, 7.637f)
        curveTo(17.41f, 7.637f, 16.906f, 7.733f, 16.447f, 7.925f)
        curveTo(15.989f, 8.117f, 15.594f, 8.397f, 15.263f, 8.765f)
        curveTo(14.933f, 9.133f, 14.674f, 9.581f, 14.487f, 10.109f)
        curveTo(14.306f, 10.637f, 14.215f, 11.237f, 14.215f, 11.909f)
        curveTo(14.215f, 12.586f, 14.311f, 13.191f, 14.503f, 13.725f)
        curveTo(14.695f, 14.253f, 14.959f, 14.701f, 15.295f, 15.069f)
        curveTo(15.631f, 15.431f, 16.026f, 15.709f, 16.479f, 15.901f)
        curveTo(16.933f, 16.093f, 17.421f, 16.189f, 17.943f, 16.189f)
        curveTo(18.263f, 16.189f, 18.549f, 16.173f, 18.799f, 16.141f)
        curveTo(19.055f, 16.103f, 19.29f, 16.047f, 19.503f, 15.973f)
        curveTo(19.717f, 15.893f, 19.917f, 15.794f, 20.103f, 15.677f)
        curveTo(20.295f, 15.559f, 20.485f, 15.415f, 20.671f, 15.245f)
        curveTo(20.778f, 15.149f, 20.885f, 15.101f, 20.991f, 15.101f)
        close()
      }
    }.build()

    return _ClearBold!!
  }


@Suppress("ObjectPropertyName")
private var _ClearBold: ImageVector? = null

