/*
 * Unitto is a calculator for Android
 * Copyright (c) 2024 Elshan Agaev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.sadellie.unitto.core.designsystem.icons.iconpack

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("UnusedReceiverParameter")
val IconPack.ArCos: ImageVector
  get() {
    if (_arCos != null) {
      return _arCos!!
    }
    _arCos =
      Builder(
          name = "ArCos",
          defaultWidth = 24.0.dp,
          defaultHeight = 24.0.dp,
          viewportWidth = 24.0f,
          viewportHeight = 24.0f,
        )
        .apply {
          path(
            fill = SolidColor(Color(0xFF000000)),
            stroke = null,
            strokeLineWidth = 0.0f,
            strokeLineCap = Butt,
            strokeLineJoin = Miter,
            strokeLineMiter = 4.0f,
            pathFillType = NonZero,
          ) {
            moveTo(5.9464f, 11.5037f)
            curveTo(5.9197f, 11.5404f, 5.8931f, 11.5687f, 5.8664f, 11.5887f)
            curveTo(5.8397f, 11.6087f, 5.8031f, 11.6187f, 5.7564f, 11.6187f)
            curveTo(5.7064f, 11.6187f, 5.6514f, 11.5987f, 5.5914f, 11.5587f)
            curveTo(5.5314f, 11.5154f, 5.4564f, 11.4687f, 5.3664f, 11.4187f)
            curveTo(5.2797f, 11.3687f, 5.1714f, 11.3237f, 5.0414f, 11.2837f)
            curveTo(4.9147f, 11.2404f, 4.7581f, 11.2187f, 4.5714f, 11.2187f)
            curveTo(4.3214f, 11.2187f, 4.1014f, 11.2637f, 3.9114f, 11.3537f)
            curveTo(3.7214f, 11.4404f, 3.5614f, 11.567f, 3.4314f, 11.7337f)
            curveTo(3.3047f, 11.9004f, 3.2081f, 12.102f, 3.1414f, 12.3387f)
            curveTo(3.0781f, 12.5754f, 3.0464f, 12.8404f, 3.0464f, 13.1337f)
            curveTo(3.0464f, 13.4404f, 3.0814f, 13.7137f, 3.1514f, 13.9537f)
            curveTo(3.2214f, 14.1904f, 3.3197f, 14.3904f, 3.4464f, 14.5537f)
            curveTo(3.5764f, 14.7137f, 3.7314f, 14.837f, 3.9114f, 14.9237f)
            curveTo(4.0947f, 15.007f, 4.2997f, 15.0487f, 4.5264f, 15.0487f)
            curveTo(4.7431f, 15.0487f, 4.9214f, 15.0237f, 5.0614f, 14.9737f)
            curveTo(5.2014f, 14.9204f, 5.3164f, 14.862f, 5.4064f, 14.7987f)
            curveTo(5.4997f, 14.7354f, 5.5764f, 14.6787f, 5.6364f, 14.6287f)
            curveTo(5.6997f, 14.5754f, 5.7614f, 14.5487f, 5.8214f, 14.5487f)
            curveTo(5.8947f, 14.5487f, 5.9514f, 14.577f, 5.9914f, 14.6337f)
            lineTo(6.2414f, 14.9587f)
            curveTo(6.1314f, 15.0954f, 6.0064f, 15.212f, 5.8664f, 15.3087f)
            curveTo(5.7264f, 15.4054f, 5.5747f, 15.487f, 5.4114f, 15.5537f)
            curveTo(5.2514f, 15.617f, 5.0831f, 15.6637f, 4.9064f, 15.6937f)
            curveTo(4.7297f, 15.7237f, 4.5497f, 15.7387f, 4.3664f, 15.7387f)
            curveTo(4.0497f, 15.7387f, 3.7547f, 15.6804f, 3.4814f, 15.5637f)
            curveTo(3.2114f, 15.447f, 2.9764f, 15.2787f, 2.7764f, 15.0587f)
            curveTo(2.5764f, 14.8354f, 2.4197f, 14.562f, 2.3064f, 14.2387f)
            curveTo(2.1931f, 13.9154f, 2.1364f, 13.547f, 2.1364f, 13.1337f)
            curveTo(2.1364f, 12.757f, 2.1881f, 12.4087f, 2.2914f, 12.0887f)
            curveTo(2.3981f, 11.7687f, 2.5514f, 11.4937f, 2.7514f, 11.2637f)
            curveTo(2.9547f, 11.0304f, 3.2031f, 10.8487f, 3.4964f, 10.7187f)
            curveTo(3.7931f, 10.5887f, 4.1331f, 10.5237f, 4.5164f, 10.5237f)
            curveTo(4.8731f, 10.5237f, 5.1864f, 10.582f, 5.4564f, 10.6987f)
            curveTo(5.7297f, 10.812f, 5.9714f, 10.9737f, 6.1814f, 11.1837f)
            lineTo(5.9464f, 11.5037f)
            close()
            moveTo(9.0439f, 10.5237f)
            curveTo(9.4139f, 10.5237f, 9.7472f, 10.5854f, 10.0439f, 10.7087f)
            curveTo(10.3406f, 10.832f, 10.5939f, 11.007f, 10.8039f, 11.2337f)
            curveTo(11.0139f, 11.4604f, 11.1739f, 11.7354f, 11.2839f, 12.0587f)
            curveTo(11.3972f, 12.3787f, 11.4539f, 12.737f, 11.4539f, 13.1337f)
            curveTo(11.4539f, 13.5337f, 11.3972f, 13.8937f, 11.2839f, 14.2137f)
            curveTo(11.1739f, 14.5337f, 11.0139f, 14.807f, 10.8039f, 15.0337f)
            curveTo(10.5939f, 15.2604f, 10.3406f, 15.4354f, 10.0439f, 15.5587f)
            curveTo(9.7472f, 15.6787f, 9.4139f, 15.7387f, 9.0439f, 15.7387f)
            curveTo(8.6706f, 15.7387f, 8.3339f, 15.6787f, 8.0339f, 15.5587f)
            curveTo(7.7372f, 15.4354f, 7.4839f, 15.2604f, 7.2739f, 15.0337f)
            curveTo(7.0639f, 14.807f, 6.9022f, 14.5337f, 6.7889f, 14.2137f)
            curveTo(6.6789f, 13.8937f, 6.6239f, 13.5337f, 6.6239f, 13.1337f)
            curveTo(6.6239f, 12.737f, 6.6789f, 12.3787f, 6.7889f, 12.0587f)
            curveTo(6.9022f, 11.7354f, 7.0639f, 11.4604f, 7.2739f, 11.2337f)
            curveTo(7.4839f, 11.007f, 7.7372f, 10.832f, 8.0339f, 10.7087f)
            curveTo(8.3339f, 10.5854f, 8.6706f, 10.5237f, 9.0439f, 10.5237f)
            close()
            moveTo(9.0439f, 15.0437f)
            curveTo(9.5439f, 15.0437f, 9.9172f, 14.877f, 10.1639f, 14.5437f)
            curveTo(10.4106f, 14.207f, 10.5339f, 13.7387f, 10.5339f, 13.1387f)
            curveTo(10.5339f, 12.5354f, 10.4106f, 12.0654f, 10.1639f, 11.7287f)
            curveTo(9.9172f, 11.392f, 9.5439f, 11.2237f, 9.0439f, 11.2237f)
            curveTo(8.7906f, 11.2237f, 8.5689f, 11.267f, 8.3789f, 11.3537f)
            curveTo(8.1922f, 11.4404f, 8.0356f, 11.5654f, 7.9089f, 11.7287f)
            curveTo(7.7856f, 11.892f, 7.6922f, 12.0937f, 7.6289f, 12.3337f)
            curveTo(7.5689f, 12.5704f, 7.5389f, 12.8387f, 7.5389f, 13.1387f)
            curveTo(7.5389f, 13.7387f, 7.6622f, 14.207f, 7.9089f, 14.5437f)
            curveTo(8.1589f, 14.877f, 8.5372f, 15.0437f, 9.0439f, 15.0437f)
            close()
            moveTo(15.3327f, 11.4387f)
            curveTo(15.2927f, 11.512f, 15.2311f, 11.5487f, 15.1477f, 11.5487f)
            curveTo(15.0977f, 11.5487f, 15.0411f, 11.5304f, 14.9777f, 11.4937f)
            curveTo(14.9144f, 11.457f, 14.8361f, 11.417f, 14.7427f, 11.3737f)
            curveTo(14.6527f, 11.327f, 14.5444f, 11.2854f, 14.4177f, 11.2487f)
            curveTo(14.2911f, 11.2087f, 14.1411f, 11.1887f, 13.9677f, 11.1887f)
            curveTo(13.8177f, 11.1887f, 13.6827f, 11.2087f, 13.5627f, 11.2487f)
            curveTo(13.4427f, 11.2854f, 13.3394f, 11.337f, 13.2527f, 11.4037f)
            curveTo(13.1694f, 11.4704f, 13.1044f, 11.5487f, 13.0577f, 11.6387f)
            curveTo(13.0144f, 11.7254f, 12.9927f, 11.8204f, 12.9927f, 11.9237f)
            curveTo(12.9927f, 12.0537f, 13.0294f, 12.162f, 13.1027f, 12.2487f)
            curveTo(13.1794f, 12.3354f, 13.2794f, 12.4104f, 13.4027f, 12.4737f)
            curveTo(13.5261f, 12.537f, 13.6661f, 12.5937f, 13.8227f, 12.6437f)
            curveTo(13.9794f, 12.6904f, 14.1394f, 12.742f, 14.3027f, 12.7987f)
            curveTo(14.4694f, 12.852f, 14.6311f, 12.912f, 14.7877f, 12.9787f)
            curveTo(14.9444f, 13.0454f, 15.0844f, 13.1287f, 15.2077f, 13.2287f)
            curveTo(15.3311f, 13.3287f, 15.4294f, 13.452f, 15.5027f, 13.5987f)
            curveTo(15.5794f, 13.742f, 15.6177f, 13.9154f, 15.6177f, 14.1187f)
            curveTo(15.6177f, 14.352f, 15.5761f, 14.5687f, 15.4927f, 14.7687f)
            curveTo(15.4094f, 14.9654f, 15.2861f, 15.137f, 15.1227f, 15.2837f)
            curveTo(14.9594f, 15.427f, 14.7594f, 15.5404f, 14.5227f, 15.6237f)
            curveTo(14.2861f, 15.707f, 14.0127f, 15.7487f, 13.7027f, 15.7487f)
            curveTo(13.3494f, 15.7487f, 13.0294f, 15.692f, 12.7427f, 15.5787f)
            curveTo(12.4561f, 15.462f, 12.2127f, 15.3137f, 12.0127f, 15.1337f)
            lineTo(12.2227f, 14.7937f)
            curveTo(12.2494f, 14.7504f, 12.2811f, 14.717f, 12.3177f, 14.6937f)
            curveTo(12.3544f, 14.6704f, 12.4011f, 14.6587f, 12.4577f, 14.6587f)
            curveTo(12.5177f, 14.6587f, 12.5811f, 14.682f, 12.6477f, 14.7287f)
            curveTo(12.7144f, 14.7754f, 12.7944f, 14.827f, 12.8877f, 14.8837f)
            curveTo(12.9844f, 14.9404f, 13.1011f, 14.992f, 13.2377f, 15.0387f)
            curveTo(13.3744f, 15.0854f, 13.5444f, 15.1087f, 13.7477f, 15.1087f)
            curveTo(13.9211f, 15.1087f, 14.0727f, 15.087f, 14.2027f, 15.0437f)
            curveTo(14.3327f, 14.997f, 14.4411f, 14.9354f, 14.5277f, 14.8587f)
            curveTo(14.6144f, 14.782f, 14.6777f, 14.6937f, 14.7177f, 14.5937f)
            curveTo(14.7611f, 14.4937f, 14.7827f, 14.387f, 14.7827f, 14.2737f)
            curveTo(14.7827f, 14.1337f, 14.7444f, 14.0187f, 14.6677f, 13.9287f)
            curveTo(14.5944f, 13.8354f, 14.4961f, 13.757f, 14.3727f, 13.6937f)
            curveTo(14.2494f, 13.627f, 14.1077f, 13.5704f, 13.9477f, 13.5237f)
            curveTo(13.7911f, 13.4737f, 13.6294f, 13.422f, 13.4627f, 13.3687f)
            curveTo(13.2994f, 13.3154f, 13.1377f, 13.2554f, 12.9777f, 13.1887f)
            curveTo(12.8211f, 13.1187f, 12.6811f, 13.032f, 12.5577f, 12.9287f)
            curveTo(12.4344f, 12.8254f, 12.3344f, 12.6987f, 12.2577f, 12.5487f)
            curveTo(12.1844f, 12.3954f, 12.1477f, 12.2104f, 12.1477f, 11.9937f)
            curveTo(12.1477f, 11.8004f, 12.1877f, 11.6154f, 12.2677f, 11.4387f)
            curveTo(12.3477f, 11.2587f, 12.4644f, 11.102f, 12.6177f, 10.9687f)
            curveTo(12.7711f, 10.832f, 12.9594f, 10.7237f, 13.1827f, 10.6437f)
            curveTo(13.4061f, 10.5637f, 13.6611f, 10.5237f, 13.9477f, 10.5237f)
            curveTo(14.2811f, 10.5237f, 14.5794f, 10.577f, 14.8427f, 10.6837f)
            curveTo(15.1094f, 10.787f, 15.3394f, 10.9304f, 15.5327f, 11.1137f)
            lineTo(15.3327f, 11.4387f)
            close()
            moveTo(16.3539f, 9.1837f)
            horizontalLineTo(18.5939f)
            verticalLineTo(9.6637f)
            horizontalLineTo(16.3539f)
            verticalLineTo(9.1837f)
            close()
            moveTo(21.7688f, 10.7437f)
            verticalLineTo(11.1687f)
            horizontalLineTo(19.7338f)
            verticalLineTo(10.7437f)
            horizontalLineTo(20.4688f)
            verticalLineTo(8.5437f)
            lineTo(20.4938f, 8.3237f)
            lineTo(19.9538f, 8.7687f)
            curveTo(19.9238f, 8.792f, 19.8938f, 8.807f, 19.8638f, 8.8137f)
            curveTo(19.8371f, 8.817f, 19.8104f, 8.817f, 19.7838f, 8.8137f)
            curveTo(19.7571f, 8.807f, 19.7321f, 8.797f, 19.7088f, 8.7837f)
            curveTo(19.6888f, 8.7704f, 19.6738f, 8.757f, 19.6638f, 8.7437f)
            lineTo(19.4688f, 8.4637f)
            lineTo(20.5788f, 7.5137f)
            horizontalLineTo(21.1188f)
            verticalLineTo(10.7437f)
            horizontalLineTo(21.7688f)
            close()
          }
        }
        .build()
    return _arCos!!
  }

private var _arCos: ImageVector? = null
