/*******************************************************************************
 *    sora-editor - the awesome code editor for Android
 *    https://github.com/Rosemoe/sora-editor
 *    Copyright (C) 2020-2024  Rosemoe
 *
 *     This library is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU Lesser General Public
 *     License as published by the Free Software Foundation; either
 *     version 2.1 of the License, or (at your option) any later version.
 *
 *     This library is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *     Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public
 *     License along with this library; if not, write to the Free Software
 *     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *     USA
 *
 *     Please contact Rosemoe by email 2073412493@qq.com if you need
 *     additional information or have any questions
 ******************************************************************************/

package io.github.rosemoe.sora.util


/**
 * An inlined enum containing useful character codes.
 */
object CharCode {

    /**
     * The `\t` character.
     */
    const val Tab = 9

    const val Space = 32

    /**
     * The `"` character.
     */
    const val DoubleQuote = 34


    /**
     * The `$` character.
     */
    const val DollarSign = 36


    /**
     * The `'` character.
     */
    const val SingleQuote = 39

    /**
     * The `(` character.
     */
    const val OpenParen = 40

    /**
     * The `)` character.
     */
    const val CloseParen = 41

    /**
     * The `-` character.
     */
    const val Dash = 45

    /**
     * The `.` character.
     */
    const val Period = 46

    /**
     * The `/` character.
     */
    const val Slash = 47


    /**
     * The `:` character.
     */
    const val Colon = 58

    /**
     * The `<` character.
     */
    const val LessThan = 60


    /**
     * The `>` character.
     */
    const val GreaterThan = 62


    /**
     * The `[` character.
     */
    const val OpenSquareBracket = 91

    /**
     * The `\` character.
     */
    const val Backslash = 92

    /**
     * The `]` character.
     */
    const val CloseSquareBracket = 93

    /**
     * The `_` character.
     */
    const val Underline = 95


    /**
     * The `{` character.
     */
    const val OpenCurlyBrace = 123

    /**
     * The `}` character.
     */
    const val CloseCurlyBrace = 125

}
