<div align="center">

![Banner](/images/editor_banner.jpg)
----
[![CI](https://github.com/Rosemoe/CodeEditor/actions/workflows/gradle.yml/badge.svg?event=push)](https://github.com/Rosemoe/CodeEditor/actions/workflows/gradle.yml)
[![GitHub license](https://img.shields.io/github/license/Rosemoe/CodeEditor)](https://github.com/Rosemoe/CodeEditor/blob/main/LICENSE)
[![Maven Central](https://img.shields.io/maven-central/v/io.github.rosemoe/editor.svg?label=Maven%20Central)]((https://search.maven.org/search?q=io.github.rosemoe%20editor))   
[![Telegram](https://img.shields.io/badge/Join-Telegram-blue)](https://t.me/rosemoe_code_editor)
[![QQ](https://img.shields.io/badge/Join-QQ_Group-ff69b4)](https://jq.qq.com/?_wv=1027&k=n68uxQws)

sora-editor is a cool and optimized code editor on Android platform

</div>

Read this in other languages: [English](README.md), [简体中文](README.zh-cn.md), [Español](README.es.md), [日本語](README.jp.md).

Note that statements in other languages may not be up-to-date.

***Work In Progress*** This project is still developing slowly.   

**Issues and pull requests are welcome.**

## Features

- [x] Incremental syntax highlight
- [x] Auto-completion (with [code snippets](https://macromates.com/manual/en/snippets))
- [x] Auto indent
- [x] Code block lines
- [x] Scale text
- [x] Undo/redo
- [x] Search and replace
- [x] Auto wordwrap
- [x] Show non-printable characters
- [x] Diagnostic markers
- [x] Text magnifier
- [x] Sticky Scroll
- [x] Highlight bracket pairs
- [x] Event System
- [x] TextMate and TreeSitter support

## Documentation

To quickly get started, please view
this [Quickstart Guide](https://project-sora.github.io/sora-editor-docs/guide/getting-started).

To check out all docs, please
visit [Documentation Site](https://project-sora.github.io/sora-editor-docs/).

* [Editor Overview](https://project-sora.github.io/sora-editor-docs/guide/editor-overview)
* [Reference](https://project-sora.github.io/sora-editor-docs/reference/xml-attributes)
* [Documentation Repository](https://github.com/project-sora/sora-editor-docs)

## Screenshots

<div style="overflow: hidden">
<img src="/images/general.jpg" alt="GeneralAppearance" width="40%" align="bottom" />
<img src="/images/problem_indicators.jpg" alt="ProblemIndicator" width="40%" align="bottom" />
</div>

## Discuss

* Official QQ Group:[734652304](https://qm.qq.com/q/kKBqRsVrQ4)
* Official [Telegram Group](https://t.me/rosemoe_code_editor)

## Contributors

<a href="https://github.com/Rosemoe/sora-editor/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=Rosemoe/sora-editor" />
</a>

## License

```
sora-editor - the awesome code editor for Android
https://github.com/Rosemoe/sora-editor
Copyright (C) 2020-2024  Rosemoe

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
USA

Please contact Rosemoe by email 2073412493@qq.com if you need
additional information or have any questions
```

## Acknowledgements

Thanks to [JetBrains](https://www.jetbrains.com/?from=CodeEditor) for allocating free open-source
licences for IDEs such as [IntelliJ IDEA](https://www.jetbrains.com/idea/?from=CodeEditor).   
[<img src=".github/jetbrains-variant-3.png" width="200"/>](https://www.jetbrains.com/?from=CodeEditor)
