package com.rk.icons

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val XedIcons.Error: ImageVector
    get() {
        if (_Error != null) return _Error!!

        _Error =
            ImageVector.Builder(
                    name = "Error",
                    defaultWidth = 24.dp,
                    defaultHeight = 24.dp,
                    viewportWidth = 960f,
                    viewportHeight = 960f,
                )
                .apply {
                    path(fill = SolidColor(Color(0xFF000000))) {
                        moveTo(480f, 680f)
                        quadToRelative(17f, 0f, 28.5f, -11.5f)
                        reflectiveQuadTo(520f, 640f)
                        reflectiveQuadToRelative(-11.5f, -28.5f)
                        reflectiveQuadTo(480f, 600f)
                        reflectiveQuadToRelative(-28.5f, 11.5f)
                        reflectiveQuadTo(440f, 640f)
                        reflectiveQuadToRelative(11.5f, 28.5f)
                        reflectiveQuadTo(480f, 680f)
                        moveToRelative(-40f, -160f)
                        horizontalLineToRelative(80f)
                        verticalLineToRelative(-240f)
                        horizontalLineToRelative(-80f)
                        close()
                        moveToRelative(40f, 360f)
                        quadToRelative(-83f, 0f, -156f, -31.5f)
                        reflectiveQuadTo(197f, 763f)
                        reflectiveQuadToRelative(-85.5f, -127f)
                        reflectiveQuadTo(80f, 480f)
                        reflectiveQuadToRelative(31.5f, -156f)
                        reflectiveQuadTo(197f, 197f)
                        reflectiveQuadToRelative(127f, -85.5f)
                        reflectiveQuadTo(480f, 80f)
                        reflectiveQuadToRelative(156f, 31.5f)
                        reflectiveQuadTo(763f, 197f)
                        reflectiveQuadToRelative(85.5f, 127f)
                        reflectiveQuadTo(880f, 480f)
                        reflectiveQuadToRelative(-31.5f, 156f)
                        reflectiveQuadTo(763f, 763f)
                        reflectiveQuadToRelative(-127f, 85.5f)
                        reflectiveQuadTo(480f, 880f)
                        moveToRelative(0f, -80f)
                        quadToRelative(134f, 0f, 227f, -93f)
                        reflectiveQuadToRelative(93f, -227f)
                        reflectiveQuadToRelative(-93f, -227f)
                        reflectiveQuadToRelative(-227f, -93f)
                        reflectiveQuadToRelative(-227f, 93f)
                        reflectiveQuadToRelative(-93f, 227f)
                        reflectiveQuadToRelative(93f, 227f)
                        reflectiveQuadToRelative(227f, 93f)
                        moveToRelative(0f, -320f)
                    }
                }
                .build()

        return _Error!!
    }

private var _Error: ImageVector? = null
