set -e

source "$LOCAL/bin/utils"

info 'Preparing installation...'
apt update && apt upgrade -y

install_nodejs() {
  info "Installing Node.js LTS..."
  apt install -y curl ca-certificates
  curl -fsSL https://deb.nodesource.com/setup_lts.x | bash -
  apt install -y nodejs

  # Remove old installation
  if [ -d "$HOME/.npm-global" ]; then
    npm uninstall -g --prefix $HOME/.npm-global bash-language-server
  fi
}

if ! command_exists node || ! command_exists npm; then
  install_nodejs
fi

info 'Installing bash language server...'
npm install -g --prefix /usr bash-language-server

info 'Installing ShellCheck...'
apt install -y shellcheck

info 'Bash language server installed successfully. Please reopen all tabs or restart the app.'
