import 'package:flutter/material.dart';

import 'style.dart';

// icons
const Map<String, IconData> householdIconList = {
  'home': Icons.home,
  'weekend': Icons.weekend,
  'blender': Icons.blender,
  'construction': Icons.construction,
  'shopping_cart': Icons.shopping_cart,
  'dry_cleaning': Icons.dry_cleaning,
  'checkroom': Icons.checkroom,
  'lightbulb': Icons.lightbulb,
  'electrical_services': Icons.electrical_services,
  'energy_savings_leaf': Icons.energy_savings_leaf,
  'router': Icons.router,
  'device_thermostat': Icons.device_thermostat,
  'water_drop': Icons.water_drop,
  'local_fire_department': Icons.local_fire_department,
  'local_gas_station': Icons.local_gas_station,
  'ev_station': Icons.ev_station,
  'bakery_dining': Icons.bakery_dining,
  'cookie': Icons.cookie,
  'fastfood': Icons.fastfood,
  'bedroom_baby': Icons.bedroom_baby,
  'cake': Icons.cake,
  'balance': Icons.balance,
  'dinner_dining': Icons.dinner_dining,
  'liquor': Icons.liquor,
  'restaurant': Icons.restaurant,
  'ramen_dining': Icons.ramen_dining,
  'vaccines': Icons.vaccines,
  'medication': Icons.medication,
  'smoking_rooms': Icons.smoking_rooms,
  'vaping_rooms': Icons.vaping_rooms,
  'airline_seat_flat': Icons.airline_seat_flat,
  'child_friendly': Icons.child_friendly,
  'pets': Icons.pets,
};
const Map<String, IconData> activitiesIconList = {
  'work': Icons.work,
  'school': Icons.school,
  'calendar_month': Icons.calendar_month,
  'videogame_asset': Icons.videogame_asset,
  'translate': Icons.translate,
  'menu_book': Icons.menu_book,
  'palette': Icons.palette,
  'biotech': Icons.biotech,
  'design_services': Icons.design_services,
  'celebration': Icons.celebration,
  'card_giftcard': Icons.card_giftcard,
  'shopping_bag': Icons.shopping_bag,
  'format_paint': Icons.format_paint,
  'park': Icons.park,
  'attractions': Icons.attractions,
  'festival_outlined': Icons.festival_outlined,
  'stadium': Icons.stadium,
  'theater_comedy': Icons.theater_comedy,
  'movie': Icons.movie,
  'local_activity': Icons.local_activity,
  'church': Icons.church,
  'store': Icons.store,
  'beach_access': Icons.beach_access,
  'fitness_center': Icons.fitness_center,
  'workspace_premium': Icons.workspace_premium,
  'emoji_events': Icons.emoji_events,
  'sports_motorsports': Icons.sports_motorsports,
  'sports_tennis': Icons.sports_tennis,
  'golf_course': Icons.golf_course,
  'sports_volleyball': Icons.sports_volleyball,
  'sports_football': Icons.sports_football,
  'sports_soccer': Icons.sports_soccer,
  'sports_basketball': Icons.sports_basketball,
};
const Map<String, IconData> travelIconList = {
  'rocket_launch': Icons.rocket_launch,
  'flight': Icons.flight,
  'local_taxi': Icons.local_taxi,
  'directions_boat': Icons.directions_boat,
  'sailing': Icons.sailing,
  'anchor': Icons.anchor,
  'agriculture': Icons.agriculture,
  'commute': Icons.commute,
  'directions_bus': Icons.directions_bus,
  'directions_railway': Icons.directions_railway,
  'tram': Icons.tram,
  'electric_scooter': Icons.electric_scooter,
  'directions_car': Icons.directions_car,
  'electric_car': Icons.electric_car,
  'local_shipping': Icons.local_shipping,
  'electric_rickshaw': Icons.electric_rickshaw,
  'pedal_bike': Icons.pedal_bike,
  'electric_bike': Icons.electric_bike,
  'two_wheeler': Icons.two_wheeler,
  'moped': Icons.moped,
  'electric_moped': Icons.electric_moped,
  'public': Icons.public,
  'place': Icons.place,
  'hotel': Icons.hotel,
  'luggage': Icons.luggage,
  'airplane_ticket': Icons.airplane_ticket,
  'airline_seat_recline_normal': Icons.airline_seat_recline_normal,
};
const Map<String, IconData> techIconList = {
  'desktop_mac': Icons.desktop_mac,
  'laptop': Icons.laptop,
  'devices': Icons.devices,
  'phone_iphone': Icons.phone_iphone,
  'sim_card': Icons.sim_card,
  'camera_alt': Icons.camera_alt,
  'image': Icons.image,
  'language': Icons.language,
  'library_music': Icons.library_music,
  'subscriptions': Icons.subscriptions,
  'music_note': Icons.music_note,
  'cloud': Icons.cloud,
  'call': Icons.call,
  'headphones': Icons.headphones,
  'shield': Icons.shield,
  'drafts': Icons.drafts,
};
const Map<String, IconData> peopleIconList = {
  'wc': Icons.wc,
  'pregnant_woman': Icons.pregnant_woman,
  'diversity_3': Icons.diversity_3,
  'family_restroom': Icons.family_restroom,
  'accessible': Icons.accessible,
  'elderly': Icons.elderly,
  'elderly_woman': Icons.elderly_woman,
  'self_improvement': Icons.self_improvement,
  'sports_martial_arts': Icons.sports_martial_arts,
  'downhill_skiing': Icons.downhill_skiing,
  'directions_run': Icons.directions_run,
  'directions_bike': Icons.directions_bike,
  'hiking': Icons.hiking,
  'face_4': Icons.face_4,
  'child_care': Icons.child_care,
  'face': Icons.face,
  'face_3': Icons.face_3,
};
const Map<String, IconData> othersIconList = {
  'real_estate_agent': Icons.real_estate_agent,
  'auto_graph': Icons.auto_graph,
  'diamond': Icons.diamond,
  'local_parking': Icons.local_parking,
  'emergency': Icons.emergency,
  'vpn_key': Icons.vpn_key,
  'bolt': Icons.bolt,
  'filter_vintage': Icons.filter_vintage,
  'ac_unit': Icons.ac_unit,
  'wb_sunny': Icons.wb_sunny,
  'mode_night': Icons.mode_night,
  'recycling': Icons.recycling,
  'favorite': Icons.favorite,
  'star': Icons.star,
  'priority_high': Icons.priority_high,
  'volunteer_activism': Icons.volunteer_activism,
  'psychology': Icons.psychology,
  'push_pin': Icons.push_pin,
  'question_mark': Icons.question_mark,
  'flag': Icons.flag,
  'percent': Icons.percent,
  'alternate_email': Icons.alternate_email,
  'block': Icons.block,
  'attach_file': Icons.attach_file,
  'sos': Icons.sos,
};
const Map<String, Map<String, IconData>> mapIconsList = {
  "Household": householdIconList,
  "Activities": activitiesIconList,
  "Travel": travelIconList,
  "Tech": techIconList,
  "People": peopleIconList,
  "Others": othersIconList,
};
const Map<String, IconData> iconList = {
  ...householdIconList,
  ...activitiesIconList,
  ...travelIconList,
  ...techIconList,
  ...peopleIconList,
  ...othersIconList,
};
const Map<String, IconData> accountIconList = {
  'payments': Icons.payments,
  'credit_card': Icons.credit_card,
  'savings': Icons.savings,
  'account_balance': Icons.account_balance,
};

// colors
const categoryColorList = [
  category1,
  category2,
  category3,
  category4,
  category5,
  category6,
  category7,
  category8,
  category9,
  category10,
  category11,
  category12,
  category13,
  category14,
  category15,
  category16,
  category17,
  category18,
  category19,
  category20,
  category21,
  category22,
  category23,
  category24,
  category25,
  category26,
  category27,
  category28,
  category29,
  category30,
  category31,
  category32,
  category33,
  category34,
  category35,
  category36,
  category37,
  category38,
  category39,
  category40,
  category41,
  category42,
  category43,
  category44,
];

const darkCategoryColorList = [
  darkCategory1,
  darkCategory2,
  darkCategory3,
  darkCategory4,
  darkCategory5,
  darkCategory6,
  darkCategory7,
  darkCategory8,
  darkCategory9,
  darkCategory10,
  darkCategory11,
  darkCategory12,
  darkCategory13,
  darkCategory14,
  darkCategory15,
  darkCategory16,
  darkCategory17,
  darkCategory18,
  darkCategory19,
  darkCategory20,
  darkCategory21,
  darkCategory22,
  darkCategory23,
  darkCategory24,
  darkCategory25,
  darkCategory26,
  darkCategory27,
  darkCategory28,
  darkCategory29,
  darkCategory30,
  darkCategory31,
  darkCategory32,
  darkCategory33,
  darkCategory34,
  darkCategory35,
  darkCategory36,
  darkCategory37,
  darkCategory38,
  darkCategory39,
  darkCategory40,
  darkCategory41,
  darkCategory42,
  darkCategory43,
  darkCategory44,
];

const accountColorList = [account1, account2, account3, account4, account5];

const darkAccountColorList = [
  darkAccount1,
  darkAccount2,
  darkAccount3,
  darkAccount4,
  darkAccount5,
];

List<Color> categoryColorListTheme = categoryColorList;
List<Color> accountColorListTheme = accountColorList;

void updateColorsBasedOnTheme(bool isDarkModeEnabled) {
  if (isDarkModeEnabled) {
    categoryColorListTheme = darkCategoryColorList;
    accountColorListTheme = darkAccountColorList;
  } else {
    categoryColorListTheme = categoryColorList;
    accountColorListTheme = accountColorList;
  }
}
