---
title: Setup Guide
layout: default
nav_order: 5
has_children: true
---
# Setup Guide

## Step 1: Install Git

Download and install Git from [https://git-scm.com/](https://git-scm.com/).

## Step 2: Install Flutter (Using FVM)

This project uses [FVM](https://fvm.app/) to manage Flutter versions, ensuring consistency and preventing compatibility issues among contributors.<br />
The installation process varies slightly depending on your operating system (Windows, macOS, or Linux). You can follow the official installation guide [here](https://fvm.app/documentation/getting-started/installation).<br />
Once FVM is installed, navigate to the project's root directory and run the following command:

```sh
fvm install
```

This will install the correct Flutter version specified for the project.

## Step 3: Set Up an IDE

Choose one of the following:

### Using Visual Studio Code:

1. Download and install Visual Studio Code from [https://code.visualstudio.com/](https://code.visualstudio.com/).
2. Install the Flutter and Dart extensions.

### Using IntelliJ IDEA or Android Studio:

1. Download and install IntelliJ IDEA or Android Studio.
2. Install the Flutter and Dart plugins.

## Step 4: Fork the repository

This is very simple, just go to the Sossoldi repository on GitHub and click on the “Fork” on the top right corner. By doing this you will create a copy of the repository on your account and it will allow you to make changes without affecting the main repository.

## (Optional) Download GitHub Desktop

If you are unfamiliar with Git you might want to use GitHub Desktop.

1. Go to this link and download GitHub Desktop. With this it will be easier to manage and submit the changes that you will do. After the download, set up your account.
2. Now comeback to your repository on GitHub and click on Code -> Open with GitHub Desktop
3. This will open GitHub Desktop and it should ask you to add the path in which you want to save the folder with the project. Then click on clone.
