---
title: Home
layout: home
nav_order: 1
---

**[Sossoldi](https://github.com/RIP-Comm/sossoldi)** is a free and open source wealth management / personal finance / Net Worth tracking app, made with Flutter.

<div align="center">
    <a href="https://ios.sossoldi.com">
        <img src="./assets/app-store-badge.svg" width="150" height="50" alt="Download on the App Store">
    </a>
    <a href="https://android.sossoldi.com">
        <img src="./assets/google-play-badge.png" width="150" height="50" alt="Get it on Google Play">
    </a>
</div>

<div>
    <img src="./assets/sossoldi_project_cover.jpg" width="1000" alt="Sossoldi icon">
</div>

## ❓ What problem we are solving & why

[Mr. Rip](https://retireinprogress.com/) is a blogger that has a [spreadsheet](https://docs.google.com/spreadsheets/d/1ilL6rBdzIQ6yRotqOKLUKI7KXFxu5_cZ5FQgdYTSHJk/edit#gid=138629885) in which he tracks his net worth. Sossoldi is a Mobile + Desktop app that aims at replacing that spreadsheet and make it easier for everyone to track their net worth even if they are not as skilled with Google sheets or Excel.

The app is being developed using the [Flutter](https://docs.flutter.dev/get-started/install) framework which makes it possible to have one codebase for different platforms (Android, iOS, Windows, macOS, Linux). We are currently working on a beta which hopefully will be out soon.

## This app is for you if you want to...

- 📈 Track their net worth
- 💸 Track your expenses to better understand where they are spending their money
- 👀 Keep track of your investments
- 🪦 Keep everything in one place like Mr. Rip

What features do we want to implement?

- 💸 Track expenses (even recurrent ones)
- 🏦 Track different bank accounts
- 📊 Graphs, statistics and reports
- 💻 All data are stored locally (with the option to share it in different platforms)
- 👀 Track investments: Stocks, Bonds, Crypto, Private equity
- 💶 Track taxes
- 💴 Net worth on different currencies
- ↔️ Import/export data
- 🔗 Link bank accounts that support the OpenBanking PSD2 API
- 🤓 Advanced onboarding

<div align="center">
<img src="./assets/sossoldi_portfolio_card.png" width="500" alt="Sossoldi icon">
</div>

## Useful links

Here is a list of useful links if you want to contribute to the project:

- [Github Repo](https://github.com/RIP-Comm/sossoldi)
- [Discord](https://discord.sossoldi.com)
- [Design file](https://www.figma.com/file/6NyY9yqunpbU7HIkbNEAL3/Sossoldi-App?node-id=0%3A1)
- [UX Research](https://www.federicopozzato.it/portfolio/sossoldi-personal-finance-app)
- [Information architecture](https://www.figma.com/file/xjVHAaHznRW1OFAJvp8DXn/Sossoldi-App---Figjam?node-id=0%3A1)

## Phase 1 (Ongoing)

We will not build the complete app all at once. We will start from the basic features and then we will move onto the others.
Phase 1 will be completed when the following features will be ready:

- 💸 Expenses (even recurrent ones) tracker
- 🤑 Income tracker
- ⚖️ Bank accounts balance (without the use of API)
- 📊 Basic stats
- 📱 Data stored only locally

The pages that will be implemented are:

- Dashboard
- Movements page
- Basic settings
- Basic onboarding
