---
title: Core Values
layout: default
nav_order: 2
---
# Sossoldi **Core Values**

At Sossoldi, our **principles** guide every aspect of our **development, usage,** and **community involvement**. Whether you are **using the app, contributing** to its **codebase**, or **engaging** with the project in any way, these **core values** must always be upheld.

## User Ownership and Data Responsibility

Our users have **full ownership** and **responsibility** for their **data**. We are committed to **protecting user privacy** and ensuring **transparency**. While we currently do **not access any user data**, if our approach evolves in the future, we will always **communicate openly** about **what is collected, how it is used, and why**.

If you choose to **switch** to another application or if Sossoldi is no longer available, you must be able to **export your data** at any time in **open and editable formats**. While it is the **user’s responsibility** to **back up their devices and databases**, we will always provide **support** to facilitate this process.

## Offline-First Functionality

The **core of this application** is designed to function **entirely offline**. Essential features like **transactions, budgeting, planning, and data import/export** must always be available **without requiring an internet connection**.

While **additional online features** are welcome, they should remain **optional** and **never compromise** the app’s **core functionality**.

## Performance and Usability

We **prioritize** features, **bug fixes,** and **improvements** that enhance the application without **compromising** its **speed** or **efficiency**. Development decisions focus on **ease of use** and **fast navigation** while staying aligned with our **planned roadmap**.

## Aiming for Seamless System Integration

Our **ultimate goal** is to **replace existing tracking systems**. While this is an **ambitious objective**, we recognize that users may still rely on their **current setups**.

As we continue **development**, we may **prioritize complementary features** such as **syncing with existing systems, online integrations,** and **compatibility** with **device hardware/software** to support a **smooth transition**.

## Open-Source Commitment and Community Respect

This is the product of many **talented contributors** who believe in these **values**. The project is distributed under the **permissive MIT license**, allowing **developers, users, and businesses** to create **value** from it.

If you plan to **develop derivative works** or **use portions** of our **codebase**, we **encourage** it. Just ensure that the **original authors** receive **proper credit**, as required by the **license**.

Above all, **respect** the **time, effort,** and **expertise** of the **contributors** who have made this app a **secure, free,** and **open-source platform**. Their **dedication** ensures that **high-quality, privacy-respecting software** remains available to **everyone** without **expectation** of anything in return.
