<div align="center">

<img src="./assets/iosicon.png" width="100" alt="Sossoldi icon">

# Sossoldi

**Wealth management app**

[![Discord](https://img.shields.io/discord/919139369774891088?style=flat&logo=discord)](https://discord.com/invite/PcaUZnvPzS)
[![Shield: Contributions Welcome](https://img.shields.io/badge/contributions-welcome-blue)](#Contributing)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

<div align="center">
    <a href="https://ios.sossoldi.com">
        <img src="./docs/assets/app-store-badge.svg" height="50" alt="Download on the App Store">
    </a>
    <a href="https://android.sossoldi.com">
        <img src="./docs/assets/google-play-badge.png" height="50" alt="Get it on Google Play">
    </a>
</div>

# Sossoldi (Wealth management app)

**Sossoldi** is a free and open source wealth management / personal finance / Net Worth tracking app, made with Flutter.


<div align="center">
<img src="./assets/sossoldi_project_cover.jpg" width="1000" alt="Sossoldi icon">
</div>
</div>


## ❓ What problem we are solving & why

[Mr. Rip](https://retireinprogress.com/) is a blogger that has a [spreadsheet](https://docs.google.com/spreadsheets/d/1ilL6rBdzIQ6yRotqOKLUKI7KXFxu5_cZ5FQgdYTSHJk/edit#gid=138629885) in which he tracks his net worth. Sossoldi is a Mobile + Desktop app that aims at replacing that spreadsheet and make it easier for everyone to track their net worth even if they are not as skilled with Google Sheets or Excel.

The app is being developed using the [Flutter](https://docs.flutter.dev/get-started/install) framework which makes it possible to have one codebase for different platforms (Android, iOS, Windows, macOS, Linux). We are currently working on a beta which hopefully will be out soon.

## This app is for you if you want to...

-   📈 track your net worth
-   💸 track your expenses to better understand where you are spending your money
-   👀 keep track of your investments
-   🪦 keep everything in one place like Mr. Rip

What features do we want to implement?
-   💸 Track expenses (even recurrent ones)
-   🏦 Track different bank accounts
-   📊 Graphs, statistics and reports
-   💻 All data are stored locally (with the option to share it in different platforms)
-   👀 Track investments: Stocks, Bonds, Crypto, Private equity
-   💶 Track taxes
-   💴 Net worth on different currencies
-   ↔️ Import/export data
-   🔗 Link bank accounts that support the OpenBanking PSD2 API
-   🤓 Advanced onboarding

<div align="center">
<img src="./assets/sossoldi_portfolio_card.png" width="500" alt="Sossoldi icon">
</div>

## Phase 1 (Ongoing)
We will not build the complete app all at once. We will start from the basic features and then we will move onto the others.
Phase 1 will be completed when the following features will be ready:
-   💸 Expenses (even recurrent ones) tracker
-   🤑 Income tracker
-   ⚖️ Bank accounts balance (without the use of API)
-   📊 Basic stats
-   📱 Data stored only locally

The pages that will be implemented are:
-   Dashboard
-   Movements page
-   Basic settings
-   Basic onboarding

## Contributing

If you want to help with this project you are more than welcome! Sossoldi is completely free and open source, the best place to start is from the issue tab and look for something that seems interesting to you. If you are unsure on where to start feel free to reach out to us on [Discord](https://discord.sossoldi.com), we will be more than happy to help you find what's best for you!

Also, you can refer to internal docs:

-   [Setup Guide](https://rip-comm.github.io/sossoldi/setup/setup.html)
-   [PR Guide](https://rip-comm.github.io/sossoldi/contributing/PR-guide.html)

### Useful links to get started
-   [Github Repo](https://github.com/RIP-Comm/sossoldi)
-   [Discord](https://discord.sossoldi.com)
-   [Design file](https://www.figma.com/file/6NyY9yqunpbU7HIkbNEAL3/Sossoldi-App?node-id=0%3A1)
-   [UX Research](https://www.federicopozzato.it/portfolio/sossoldi-personal-finance-app)
-   [Information architecture](https://www.figma.com/file/xjVHAaHznRW1OFAJvp8DXn/Sossoldi-App---Figjam?node-id=0%3A1)

#### New to Flutter? Here are some good (and free!) resources:
-   [FreeCodeCampCourses](https://www.youtube.com/c/Freecodecamp/search?query=flutter)
-   [Flutter Documentation](https://docs.flutter.dev/#new-to-flutter)
-   [Flutter for beginners](https://www.youtube.com/playlist?list=PL4cUxeGkcC9jLYyp2Aoh6hcWuxFDX6PBJ)
-   [Flutter course in italian](https://www.youtube.com/channel/UCYhryp9JC06XRKQUQsLZlfQ)
