package com.example.util.simpletimetracker.core.mapper

import javax.inject.Inject
import kotlin.math.roundToLong

class StatisticsMapper @Inject constructor() {

    fun getDurationPercentString(
        sumDuration: Long,
        duration: Long,
        statisticsSize: Int,
    ): String {
        val durationPercent = if (sumDuration != 0L) {
            duration * 100f / sumDuration
        } else {
            100f / statisticsSize
        }.roundToLong()

        return if (durationPercent == 0L) {
            "<1%"
        } else {
            "$durationPercent%"
        }
    }
}