package com.example.util.simpletimetracker.data_local.activityFilter

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "activityFilters")
data class ActivityFilterDBO(
    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id")
    val id: Long,

    // Longs stored in string comma separated
    @ColumnInfo(name = "selectedIds")
    val selectedIds: String,

    @ColumnInfo(name = "type")
    val type: Long,

    @ColumnInfo(name = "name")
    val name: String,

    @ColumnInfo(name = "color")
    val color: Int,

    // If not empty - take color from here, custom colorInt stored as text.
    @ColumnInfo(name = "color_int")
    val colorInt: String,

    @ColumnInfo(name = "selected")
    val selected: Boolean,
)