package com.example.util.simpletimetracker.feature_dialogs.duration.model

import com.example.util.simpletimetracker.feature_dialogs.duration.customView.DurationView

data class DurationDialogState(
    val showDisableButton: Boolean,
    val showSeconds: Boolean,
    val value: Value,
) {

    sealed interface Value {
        data class Duration(val data: DurationView.ViewData) : Value
        data class Count(val data: Long) : Value

        fun getDurationSeconds(): Long {
            return when (this) {
                is Duration -> data.seconds + data.minutes * 60L + data.hours * 3600L
                is Count -> data
            }
        }
    }
}