![Preview](https://raw.githubusercontent.com/jmiguelrivas/mako/refs/heads/master/fastlane/metadata/android/en-US/images/featureGraphic.png)

# Mako

**Mako** is a **minimal, privacy-first Android launcher** designed for focus, speed, and
simplicity.

Built entirely in **native Kotlin**, Mako runs fully **on-device**, avoids tracking, and keeps
distractions to a minimum by emphasizing clarity and intentional interaction.

<p align="center">
<a href="https://github.com/jmiguelrivas/mako/releases"><img alt="GitHub releases" src="https://img.shields.io/github/release/jmiguelrivas/mako.svg"></a>
<a href="https://www.gnu.org/licenses/gpl-3.0"><img alt="License: GPLv3" src="https://img.shields.io/badge/License-GPL%20v3-blue.svg"></a>
<a href="https://github.com/jmiguelrivas/mako/actions"><img alt="Build Status" src="https://github.com/jmiguelrivas/mako/actions/workflows/android.yml/badge.svg?branch=master"></a>
</p>

---

## • Screenshots

| Home | Settings | About |
| - | - | - |
| ![Home](https://raw.githubusercontent.com/jmiguelrivas/mako/refs/heads/master/fastlane/metadata/android/en-US/images/phoneScreenshots/1.png) | ![Settings](https://raw.githubusercontent.com/jmiguelrivas/mako/refs/heads/master/fastlane/metadata/android/en-US/images/phoneScreenshots/2.png) | ![About](https://raw.githubusercontent.com/jmiguelrivas/mako/refs/heads/master/fastlane/metadata/android/en-US/images/phoneScreenshots/3.png) |

---

## • Permissions

Mako Launcher requires **only essential permissions**:

- **Set as Home App** – to function as a launcher
- **Query Installed Apps** – to list and launch applications

No network access is required.

---

## • Features

- **Favorites & sorting**: Long press an app to quickly access actions and mark it as favorite.
  Favorite apps appear at the top of the list.
- **Battery monitoring**: Monitor battery status and performance:
    - **Temperature**: Device temperature labeled as `Warm`, `Hot`, or `Critical` when running
      higher than normal.
    - **Charging & discharging speed**: Displayed as relative multipliers (`1x`, `2x`, `3x`):
        - Higher numbers indicate faster charging.
        - Lower numbers indicate slower discharging (better battery efficiency).  
          These indicators help you make informed choices to protect your battery and maintain
          device performance.
- **Day of the year**: Track the current day of the year at a glance for productivity or personal
  tracking.

Mako encourages **mindful device usage**, helping you reduce distractions and monitor your hardware
health.

---

## • Installation

### From Releases

Download the latest APK from the **[Releases page](https://github.com/jmiguelrivas/mako/releases)**

---

## • License

[![GNU GPLv3 Image](https://www.gnu.org/graphics/gplv3-127x51.png)](https://www.gnu.org/licenses/gpl-3.0.en.html)

**Mako Launcher** is Free Software. You are free to use, study, share, and improve it under the
terms of the **GNU General Public License v3** or later.

---

## • Acknowledgements

Inspired by [YAML Launcher](https://f-droid.org/en/packages/eu.ottop.yamlauncher/) and other
privacy-focused Android tooling.
