package com.raiiware.forcestophelper.applicationlist;

import java.util.Comparator;


enum ApplicationSortingOrder {

    APPLICATION_LABEL(applicationLabelComparator()),
    FIRST_INSTALL_TIME_DESCENDING(firstInstallTimeDescendingComparator()),
    LAST_UPDATE_TIME_DESCENDING(lastUpdateTimeDescendingComparator()),
    ;

    private final Comparator<Application> applicationComparator;

    ApplicationSortingOrder(Comparator<Application> applicationComparator) {
        this.applicationComparator = applicationComparator;
    }

    public Comparator<Application> getApplicationComparator() {
        return applicationComparator;
    }

    private static Comparator<Application> applicationLabelComparator() {
        return ApplicationComparators.SYSTEM_APPS_LAST_COMPARATOR
                .thenComparing(ApplicationComparators.EMPTY_LABEL_APPS_LAST_COMPARATOR)
                .thenComparing(ApplicationComparators.APPLICATION_LABEL_COMPARATOR)
                .thenComparing(ApplicationComparators.PACKAGE_NAME_COMPARATOR)
                ;
    }

    private static Comparator<Application> firstInstallTimeDescendingComparator() {
        return ApplicationComparators.SYSTEM_APPS_LAST_COMPARATOR
                .thenComparing(ApplicationComparators.EMPTY_LABEL_APPS_LAST_COMPARATOR)
                .thenComparing(ApplicationComparators.FIRST_INSTALL_TIME_COMPARATOR.reversed())
                .thenComparing(ApplicationComparators.APPLICATION_LABEL_COMPARATOR)
                .thenComparing(ApplicationComparators.PACKAGE_NAME_COMPARATOR)
                ;
    }

    private static Comparator<Application> lastUpdateTimeDescendingComparator() {
        return ApplicationComparators.SYSTEM_APPS_LAST_COMPARATOR
                .thenComparing(ApplicationComparators.EMPTY_LABEL_APPS_LAST_COMPARATOR)
                .thenComparing(ApplicationComparators.LAST_UPDATE_TIME_COMPARATOR.reversed())
                .thenComparing(ApplicationComparators.APPLICATION_LABEL_COMPARATOR)
                .thenComparing(ApplicationComparators.PACKAGE_NAME_COMPARATOR)
                ;
    }
}
