package com.raiiware.forcestophelper.applicationlist;

import android.content.pm.PackageManager;

import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;


@MainThread
final class ApplicationListDataBuilder {

    private final ApplicationFinder applicationFinder;

    ApplicationListDataBuilder(PackageManager packageManager) {
        this.applicationFinder = new ApplicationFinder(packageManager);
    }

    @WorkerThread
    ApplicationListData buildApplicationListData(ApplicationCriteria applicationCriteria, Comparator<Application> applicationComparator, Set<String> pinnedPackageNames) {
        final List<Application> applicationList = applicationFinder.findApplications(applicationCriteria);
        applicationList.sort(applicationComparator);

        final List<Application> pinnedList   = new ArrayList<>(pinnedPackageNames.size());
        final List<Application> unpinnedList = new ArrayList<>(applicationList.size());

        for (final var application : applicationList) {
            if (pinnedPackageNames.contains(application.getPackageName())) {
                pinnedList.add(application);

            } else {
                unpinnedList.add(application);
            }
        }

        return new ApplicationListData(
                pinnedList
                , unpinnedList
        );
    }
}
