package com.raiiware.forcestophelper.applicationlist;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;

import java.util.List;
import java.util.stream.Collectors;


@MainThread
final class ApplicationFinder {

    private final PackageManager packageManager;

    ApplicationFinder(PackageManager packageManager) {
        this.packageManager = packageManager;
    }

    @WorkerThread
    List<Application> findApplications(ApplicationCriteria applicationCriteria) {
        final int flags =
                PackageManager.MATCH_UNINSTALLED_PACKAGES
                | PackageManager.MATCH_DISABLED_COMPONENTS
                ;

        final List<PackageInfo> installedPackages = packageManager.getInstalledPackages(flags);

        return installedPackages.stream()
                .filter(packageInfo -> packageInfo.applicationInfo != null)
                .map(packageInfo -> new Application(packageInfo.applicationInfo, packageInfo, packageManager))
                .filter(application -> shouldBeIncluded(application, applicationCriteria))
                .collect(Collectors.toList())
                ;
    }

    private static boolean shouldBeIncluded(Application application, ApplicationCriteria applicationCriteria) {
        if (application.isStopped()) {
            if (! applicationCriteria.shouldIncludeStoppedApps()) return false;
        }

        final var query = applicationCriteria.getQuery();
        return containsIgnoreCase(application.getApplicationLabel(), query)
            || contains          (application.getPackageName(),      query);
    }

    public static boolean contains(String str, String query) {
        if (TextUtils.isEmpty(query)) return true;
        return str.contains(query);
    }

    public static boolean containsIgnoreCase(String str, String query) {
        if (TextUtils.isEmpty(query)) return true;
        return (str.toLowerCase()).contains(query.toLowerCase());
    }
}
