package com.raiiware.forcestophelper.applicationlist;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;

import java.util.Objects;


final class Application {

    private final ApplicationInfo applicationInfo;
    private final PackageInfo     packageInfo;
    private final PackageManager  packageManager;
    private final String          applicationLabel;

    Application(ApplicationInfo applicationInfo, PackageInfo packageInfo, PackageManager packageManager) {
        this.applicationInfo  = applicationInfo;
        this.packageInfo      = packageInfo;
        this.packageManager   = packageManager;
        this.applicationLabel = buildApplicationLabel(applicationInfo, packageManager);
    }

    private static String buildApplicationLabel(ApplicationInfo applicationInfo, PackageManager packageManager) {
        final String applicationLabel = applicationInfo.loadLabel(packageManager).toString();
        if (TextUtils.equals(applicationLabel, applicationInfo.packageName)) return "";

        return applicationLabel;
    }

    String getPackageName() {
        return applicationInfo.packageName;
    }

    String getApplicationLabel() {
        return applicationLabel;
    }

    Drawable getApplicationIcon() {
        return applicationInfo.loadIcon(packageManager);
    }

    boolean isEnabled() {
        return applicationInfo.enabled;
    }

    boolean isStopped() {
        return (applicationInfo.flags & ApplicationInfo.FLAG_STOPPED) != 0;
    }

    boolean isSystemApp() {
        return (applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0;
    }

    long getFirstInstallTime() {
        return packageInfo.firstInstallTime;
    }

    long getLastUpdateTime() {
        return packageInfo.lastUpdateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        final Application that = (Application) o;
        return Objects.equals(applicationInfo.packageName, that.applicationInfo.packageName)
               && Objects.equals(applicationLabel, that.applicationLabel)
                ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(applicationInfo.packageName
                , applicationLabel
        );
    }
}
