package com.raiiware.forcestophelper.applicationlist;


final class ApplicationCriteriaBuilder {

    private boolean includeStoppedApps;
    private String  query;

    ApplicationCriteriaBuilder() {
        this.includeStoppedApps = false;
        this.query              = "";
    }

    boolean shouldIncludeStoppedApps() {
        return includeStoppedApps;
    }

    void toggleIncludeStoppedApps() {
        this.includeStoppedApps = !(includeStoppedApps);
    }

    void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return query;
    }

    ApplicationCriteria build() {
        return new ApplicationCriteria(
                includeStoppedApps
                , query
        );
    }
}
