package com.raiiware.forcestophelper.database;

import androidx.room.Dao;
import androidx.room.Query;

import java.util.List;


@Dao
public interface PinnedApplicationDao {

    @Query("INSERT OR IGNORE INTO pinned_applications(package_name) VALUES(:packageName)")
    void registerPinnedApplication(String packageName);

    @Query("DELETE FROM pinned_applications WHERE package_name = :packageName")
    void unregisterPinnedApplication(String packageName);

    @Query("SELECT package_name FROM pinned_applications")
    List<String> getPinnedPackageNames();
}
