package com.raiiware.forcestophelper.applicationlist;

import android.content.Context;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;

import androidx.appcompat.widget.PopupMenu;

import com.raiiware.forcestophelper.R;


final class ApplicationItemPopupMenu {

    private final PopupMenu                popupMenu;
    private final ApplicationListViewModel viewModel;
    private final Application              application;

    ApplicationItemPopupMenu(Context context, View anchor, ApplicationListViewModel viewModel, Application application, boolean pinned) {
        final var popupMenu = new PopupMenu(context, anchor);

        final var menu = popupMenu.getMenu();
        popupMenu.getMenuInflater().inflate(R.menu.application_list_application_item, menu);
        setUpMenu(menu, pinned);

        popupMenu.setOnMenuItemClickListener(this::onMenuItemClick);

        this.popupMenu   = popupMenu;
        this.viewModel   = viewModel;
        this.application = application;
    }

    private void setUpMenu(Menu menu, boolean pinned) {
        final var pinMenuItem   = menu.findItem(R.id.action_pin);
        final var unpinMenuItem = menu.findItem(R.id.action_unpin);

        if (pinned) {
            pinMenuItem.setVisible(false);
            unpinMenuItem.setVisible(true);

        } else {
            pinMenuItem.setVisible(true);
            unpinMenuItem.setVisible(false);
        }
    }

    void show() {
        popupMenu.show();
    }

    private boolean onMenuItemClick(MenuItem item)  {
        final var itemId = item.getItemId();

        if (itemId == R.id.action_pin) {
            viewModel.setApplicationPinned(application, true);
            return true;
        }

        if (itemId == R.id.action_unpin) {
            viewModel.setApplicationPinned(application, false);
            return true;
        }

        return false;
    }
}
