package com.raiiware.forcestophelper.applicationlist;

import android.text.TextUtils;

import java.util.Comparator;


final class ApplicationComparators {

    static final Comparator<Application> SYSTEM_APPS_LAST_COMPARATOR = (o1, o2) -> {
        if (o1.isSystemApp() && !o2.isSystemApp()) return +1;
        if (!o1.isSystemApp() && o2.isSystemApp()) return -1;
        return 0;
    };

    static final Comparator<Application> EMPTY_LABEL_APPS_LAST_COMPARATOR = (o1, o2) -> {
        if (TextUtils.isEmpty(o1.getApplicationLabel()) && !TextUtils.isEmpty(o2.getApplicationLabel())) return +1;
        if (!TextUtils.isEmpty(o1.getApplicationLabel()) && TextUtils.isEmpty(o2.getApplicationLabel())) return -1;
        return 0;
    };

    static final Comparator<Application> APPLICATION_LABEL_COMPARATOR =
            (o1, o2) -> CharSequence.compare(o1.getApplicationLabel(), o2.getApplicationLabel());

    static final Comparator<Application> PACKAGE_NAME_COMPARATOR =
            (o1, o2) -> CharSequence.compare(o1.getPackageName(), o2.getPackageName());

    static final Comparator<Application> FIRST_INSTALL_TIME_COMPARATOR =
            Comparator.comparingLong(Application::getFirstInstallTime);

    static final Comparator<Application> LAST_UPDATE_TIME_COMPARATOR =
            Comparator.comparingLong(Application::getLastUpdateTime);
}
