package com.raiiware.forcestophelper;

import android.os.Bundle;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import com.raiiware.forcestophelper.applicationlist.ApplicationListFragment;


public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, windowInsets) -> {
            final Insets systemBars    = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars());
            final Insets displayCutout = windowInsets.getInsets(WindowInsetsCompat.Type.displayCutout());

            final Insets padding = Insets.of(
                    Integer.max(systemBars.left, displayCutout.left),
                    0,
                    Integer.max(systemBars.right, displayCutout.right),
                    0
            );
            v.setPadding(padding.left, padding.top, padding.right, padding.bottom);
            return windowInsets.inset(Insets.of(0, 0, 0, 0));
        });

        final Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        if (savedInstanceState == null) {
            getSupportFragmentManager().beginTransaction()
                    .setReorderingAllowed(true)
                    .replace(R.id.container, ApplicationListFragment.newInstance())
                    .commitNow();
        }
    }
}
