import "dart:io";

import 'package:html/parser.dart' show parse;
import 'package:recase/recase.dart';

void main(List<String> args) {
  File fontsPreviewFile = File(args[0]);

  if (!fontsPreviewFile.existsSync()) {
    print('lucide preview file not found');
    exit(0);
  }

  String content = fontsPreviewFile.readAsStringSync();
  final c = parse(content);
  final list = c.getElementsByClassName('glyph');

  List<String> generatedOutput = [
    "library lucide_icons;\n",
    "import \"package:flutter/widgets.dart\";\n",
    "import \"src/icon_data.dart\";\n\n",
    "// THIS FILE IS AUTOMATICALLY GENERATED!\n\n",
    "class LucideIcons {\n"
  ];

  for (final icon in list) {
    final name = icon
        .getElementsByClassName('class')
        .first
        .attributes['value']!
        .replaceFirst('.icon-', '');
    final val = icon
        .getElementsByClassName('point')
        .first
        .attributes['value']!
        .replaceFirst('&#x', '')
        .replaceFirst(';', '');

    generatedOutput.add(
        "static const IconData ${ReCase(name).camelCase} = const LucideIconData(0x$val);\n");

    print('$val $name');
  }

  generatedOutput.add("}\n");

  File output = File('./lib/lucide_icons.dart');
  output.writeAsStringSync(generatedOutput.join());
}
