#include <jni.h>
#include <malloc.h>
#include "EffectProfileBuffer.h"
#include "ControllerEventData.h"
#include "SampleHandle.h"
#include "LowPassBuffer.h"
#include "VolumeBuffer.h"
#include "DelayBuffer.h"
#include "PanBuffer.h"

extern "C" JNIEXPORT jlong JNICALL
Java_com_qfs_apres_soundfontplayer_ProfileBuffer_00024Companion_create(JNIEnv* env, jobject, jlong cev_ptr, jint start_frame) {
    auto* controller_event_data = (ControllerEventData *)cev_ptr;
    EffectProfileBuffer* buffer;
    switch (controller_event_data->type) {
        case TYPE_DELAY: {
            auto* derived_buffer = (DelayBuffer*)malloc(sizeof(DelayBuffer));
            new (derived_buffer) DelayBuffer(controller_event_data, start_frame);
            buffer = derived_buffer;
            break;
        }
        case TYPE_PAN: {
            auto* derived_buffer = (PanBuffer*)malloc(sizeof(PanBuffer));
            new (derived_buffer) PanBuffer(controller_event_data, start_frame);
            buffer = derived_buffer;
            break;
        }
        case TYPE_VOLUME: {
            auto* derived_buffer = (VolumeBuffer*)malloc(sizeof(VolumeBuffer));
            new (derived_buffer) VolumeBuffer(controller_event_data, start_frame);
            buffer = derived_buffer;
            break;
        }
        case TYPE_LOWPASS: {
            auto* derived_buffer = (LowPassBuffer*)malloc(sizeof(LowPassBuffer));
            new (derived_buffer) LowPassBuffer(controller_event_data, start_frame);
            buffer = derived_buffer;
            break;
        }
        default: {
            buffer = (EffectProfileBuffer*)malloc(sizeof(EffectProfileBuffer));
        }
    }
    return (jlong)buffer;
}

extern "C" JNIEXPORT jlong JNICALL
Java_com_qfs_apres_soundfontplayer_ProfileBuffer_copy_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (struct EffectProfileBuffer *) ptr_long;
    EffectProfileBuffer* buffer;
    switch (ptr->data->type) {
        case TYPE_DELAY: {
            auto* original = (DelayBuffer*)ptr;
            auto* derived_buffer = (DelayBuffer*)malloc(sizeof(DelayBuffer));
            new (derived_buffer) DelayBuffer(original);
            buffer = derived_buffer;
            break;
        }
        case TYPE_PAN: {
            auto* original = (PanBuffer*)ptr;
            auto* derived_buffer = (PanBuffer*)malloc(sizeof(PanBuffer));
            new (derived_buffer) PanBuffer(original);
            buffer = derived_buffer;
            break;
        }
        case TYPE_VOLUME: {
            auto* original = (VolumeBuffer*)ptr;
            auto* derived_buffer = (VolumeBuffer*)malloc(sizeof(VolumeBuffer));
            new (derived_buffer) VolumeBuffer(original);
            buffer = derived_buffer;
            break;
        }
        case TYPE_LOWPASS: {
            auto* original = (LowPassBuffer*)ptr;
            auto* derived_buffer = (LowPassBuffer*)malloc(sizeof(LowPassBuffer));
            new (derived_buffer) LowPassBuffer(original);
            buffer = derived_buffer;
            break;
        }
        default: {
            buffer = (EffectProfileBuffer*)malloc(sizeof(EffectProfileBuffer));
            new (buffer) EffectProfileBuffer(ptr);
        }
    }

    return (jlong)buffer;
}

extern "C" JNIEXPORT jlong JNICALL
Java_com_qfs_apres_soundfontplayer_ProfileBuffer_get_1data_1ptr_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (EffectProfileBuffer *) ptr_long;
    return (jlong)ptr->data;
}

extern "C" JNIEXPORT void JNICALL
Java_com_qfs_apres_soundfontplayer_ProfileBuffer_destroy_1jni(JNIEnv* env, jobject, jlong ptr_long, jboolean deep) {
    auto *ptr = (EffectProfileBuffer *) ptr_long;
    int type = ptr->data->type;
    if (deep) delete ptr->data;

    switch (type) {
        case TYPE_DELAY: {
            auto* original =(DelayBuffer*)ptr;
            original->~DelayBuffer();
            free(original);
            break;
        }
        case TYPE_PAN: {
            auto* original =(PanBuffer*)ptr;
            original->~PanBuffer();
            free(original);
            break;
        }
        case TYPE_VOLUME: {
            auto* original =(VolumeBuffer*)ptr;
            original->~VolumeBuffer();
            free(original);
            break;
        }
        case TYPE_LOWPASS: {
            auto* original =(LowPassBuffer*)ptr;
            original->~LowPassBuffer();
            free(original);
            break;
        }
        default: {
            ptr->~EffectProfileBuffer();
            free(ptr);
        }
    }
}

extern "C" JNIEXPORT void JNICALL
Java_com_qfs_apres_soundfontplayer_ProfileBuffer_set_1frame_1jni(JNIEnv* env, jobject, jlong ptr_long, jint frame) {
    auto *ptr = (EffectProfileBuffer *) ptr_long;
    ptr->set_frame(frame);
}

extern "C" JNIEXPORT jboolean JNICALL
Java_com_qfs_apres_soundfontplayer_ProfileBuffer_allow_1empty_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (EffectProfileBuffer *) ptr_long;

    bool output;
    switch (ptr->data->type) {
        case TYPE_DELAY: {
            auto* typed_ptr = (DelayBuffer*) ptr_long;
            output = typed_ptr->has_pending_echoes();
            break;
        }
        case TYPE_LOWPASS: {
            auto* typed_ptr = (LowPassBuffer*) ptr_long;
            output = typed_ptr->in_smoothing();
            break;
        }
        default: {
            output = false;
        }
    }
    return (jboolean)output;
}
