package com.qfs.pagan.controlwidgets

import android.content.Context
import android.view.ContextThemeWrapper
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.widget.LinearLayoutCompat
import com.qfs.pagan.Activity.ActivityEditor
import com.qfs.pagan.structure.opusmanager.base.CtlLineLevel
import com.qfs.pagan.structure.opusmanager.base.effectcontrol.event.EffectEvent

abstract class ControlWidget<T: EffectEvent>(context: Context, var level: CtlLineLevel, var is_initial_event: Boolean, val layout_id: Int, val callback: (T) -> Unit): LinearLayoutCompat(context, null) {
    abstract fun on_set(event: T)
    abstract fun on_inflated()
    internal lateinit var inner: View
    var working_event: T? = null

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        this.inner = LayoutInflater.from(this.context)
            .inflate(
                this.layout_id,
                this.parent as ViewGroup?,
                false
            )
        this.addView(this.inner)

        this.on_inflated()
    }

    override fun onLayout(changed: Boolean, l: Int, t: Int, r: Int, b: Int) {
        super.onLayout(changed, l, t, r, b)
    }

    fun get_event(): T {
        return this.working_event!!
    }
    fun set_event(event: T, surpress_callback: Boolean = false) {
        if (event == this.working_event) {
            return
        }
        this.working_event = event
        this.on_set(event)
        if (!surpress_callback) {
            this.callback(event)
        }
    }

    fun get_activity(): ActivityEditor {
        var working_context = this.context
        while (working_context !is ActivityEditor) {
            working_context = (working_context as ContextThemeWrapper).baseContext
        }
        return working_context
    }

}
