#include "SampleHandle.h"
#include <string>

extern "C" JNIEXPORT jfloatArray JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_get_1next_1frames_1jni(JNIEnv* env, jobject, jlong ptr_long, jint size, jint left_padding) {
    auto *ptr = (SampleHandle *)ptr_long;
    jfloat buffer[size * 2];
    ptr->get_next_frames(buffer, size, left_padding);

    jfloatArray output = env->NewFloatArray(size * 2);
    env->SetFloatArrayRegion(output, 0, size * 2, buffer);
    return output;
}

extern "C" JNIEXPORT jint JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_get_1uuid_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *)ptr_long;
    return ptr->uuid;
}

extern "C" JNIEXPORT jlong JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_get_1volume_1envelope_1ptr(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *)ptr_long;
    return (jlong)ptr->volume_envelope;
}

extern "C" JNIEXPORT void JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_set_1working_1frame_1jni(JNIEnv* env, jobject, jlong ptr_long, jint frame) {
    auto *ptr = (SampleHandle *)ptr_long;
    ptr->set_working_frame(frame);
}

extern "C" JNIEXPORT void JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_set_1release_1frame_1jni(JNIEnv* env, jobject, jlong ptr_long, jint frame) {
    auto *ptr = (SampleHandle *)ptr_long;
    ptr->set_release_frame(frame);
}

extern "C" JNIEXPORT void JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_release_1note_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *)ptr_long;
    ptr->release_note();
}

extern "C" JNIEXPORT void JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_set_1kill_1frame_1jni(JNIEnv* env, jobject, jlong ptr_long, jint frame) {
    auto *ptr = (SampleHandle *)ptr_long;
    ptr->set_kill_frame(frame);
}

extern "C" JNIEXPORT void JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_repitch_1jni(JNIEnv* env, jobject, jlong ptr_long, jfloat new_pitch) {
    auto *ptr = (SampleHandle *)ptr_long;
    ptr->repitch(new_pitch);
}

extern "C" JNIEXPORT jint JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_get_1release_1duration_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *)ptr_long;
    return ptr->get_release_duration();
}

extern "C" JNIEXPORT jint JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_get_1release_1frame_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *)ptr_long;
    return ptr->release_frame;
}

extern "C" JNIEXPORT jlong JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_00024Companion_create(
        JNIEnv* env,
        jobject,
        jlong data_ptr_long,
        jint sample_rate,
        jfloat initial_attenuation,
        jint loop_start,
        jint loop_end,
        jint stereo_mode,
        jlong volume_envelope_ptr,
        jfloat pitch_shift,
        jfloat filter_cutoff,
        jfloat pan,
        jfloat vibrato_frequency,
        jfloat vibrato_delay,
        jfloat vibrato_pitch
) {

    auto* volume_envelope = (VolumeEnvelope*)malloc(sizeof(VolumeEnvelope));
    new (volume_envelope) VolumeEnvelope((VolumeEnvelope*) volume_envelope_ptr);

    auto* handle = (SampleHandle*)malloc(sizeof(SampleHandle));
    new (handle) SampleHandle(
            (SampleData*)data_ptr_long,
            sample_rate,
            initial_attenuation,
            loop_start,
            loop_end,
            stereo_mode,
            volume_envelope,
            pitch_shift,
            filter_cutoff,
            pan,
            vibrato_frequency,
            vibrato_delay,
            vibrato_pitch
    );

    return (jlong)handle;
}

extern "C" JNIEXPORT jlong JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_copy_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *) ptr_long;
    auto* new_handle = (SampleHandle*)malloc(sizeof(SampleHandle));
    new (new_handle) SampleHandle(ptr);

    return (jlong)new_handle;
}

extern "C" JNIEXPORT jboolean JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_is_1dead_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *) ptr_long;
    return ptr->is_dead;
}

extern "C" JNIEXPORT jint JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_get_1working_1frame_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *) ptr_long;
    return ptr->working_frame;
}

extern "C" JNIEXPORT void JNICALL
Java_com_qfs_apres_soundfontplayer_SampleHandle_destroy_1jni(JNIEnv* env, jobject, jlong ptr_long) {
    auto *ptr = (SampleHandle *) ptr_long;
    delete ptr;
}
